/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.compat.jei;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.compat.jei.CrystalToolsCraftingCategoryExtension;
import dev.willyelton.crystal_tools.common.compat.jei.CrystalToolsRecipeTypes;
import dev.willyelton.crystal_tools.common.compat.jei.generator.GeneratorRecipe;
import dev.willyelton.crystal_tools.common.compat.jei.generator.GeneratorRecipeCategory;
import dev.willyelton.crystal_tools.common.compat.jei.pedestal.PedestalRecipe;
import dev.willyelton.crystal_tools.common.compat.jei.pedestal.PedestalRecipeCategory;
import dev.willyelton.crystal_tools.common.crafting.CrystalToolsRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CrystalToolsJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"jeiplugin");
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(CrystalToolsRecipe.class, (ICraftingCategoryExtension)new CrystalToolsCraftingCategoryExtension());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Registration.CRYSTAL_FURNACE_ITEM.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Registration.CRYSTAL_GENERATOR.get()), new RecipeType[]{CrystalToolsRecipeTypes.GENERATOR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Registration.CRYSTAL_PEDESTAL.get()), new RecipeType[]{CrystalToolsRecipeTypes.PEDESTAL});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new GeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PedestalRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CrystalToolsRecipeTypes.GENERATOR, GeneratorRecipe.createGeneratorRecipes(registration.getIngredientManager()));
        registration.addRecipes(CrystalToolsRecipeTypes.PEDESTAL, PedestalRecipe.createPedestalRecipes(registration.getIngredientManager()));
    }
}

