/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.compat.jei.generator;

import dev.willyelton.crystal_tools.common.datamap.DataMaps;
import dev.willyelton.crystal_tools.common.datamap.GeneratorFuelData;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalGeneratorBlockEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.core.Holder;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public record GeneratorRecipe(ItemStack stack, int burnTime, int bonusGeneration, String upgradeRequired) {
    public static List<GeneratorRecipe> createGeneratorRecipes(IIngredientManager ingredientManager) {
        ArrayList<GeneratorRecipe> recipes = new ArrayList<GeneratorRecipe>();
        for (ItemStack stack : ingredientManager.getAllItemStacks()) {
            int burnTime;
            Holder holder = stack.getItemHolder();
            GeneratorFuelData gemFuelData = (GeneratorFuelData)holder.getData(DataMaps.GENERATOR_GEMS);
            if (gemFuelData != null) {
                recipes.add(new GeneratorRecipe(stack, gemFuelData.burnTime(), gemFuelData.bonusGeneration(), "Gem Generator"));
                continue;
            }
            GeneratorFuelData metalFuelData = (GeneratorFuelData)holder.getData(DataMaps.GENERATOR_METALS);
            if (metalFuelData != null) {
                recipes.add(new GeneratorRecipe(stack, metalFuelData.burnTime(), metalFuelData.bonusGeneration(), "Metal Generator"));
                continue;
            }
            FoodProperties foodProperties = stack.getFoodProperties(null);
            if (foodProperties != null && (burnTime = CrystalGeneratorBlockEntity.getBurnTimeFromFood(foodProperties)) > 0) {
                recipes.add(new GeneratorRecipe(stack, burnTime, 0, "Food Generator"));
                continue;
            }
            burnTime = stack.getBurnTime(null);
            if (burnTime == 0) continue;
            recipes.add(new GeneratorRecipe(stack, burnTime, 0, ""));
        }
        recipes.sort(Comparator.comparing(GeneratorRecipe::upgradeRequired).thenComparing(GeneratorRecipe::bonusGeneration).thenComparing(GeneratorRecipe::burnTime));
        return recipes;
    }
}

