/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.compat.jei.generator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dev.willyelton.crystal_tools.common.compat.jei.CrystalToolsRecipeTypes;
import dev.willyelton.crystal_tools.common.compat.jei.generator.GeneratorRecipe;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GeneratorRecipeCategory
implements IRecipeCategory<GeneratorRecipe> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_generator_category.png");
    private final IDrawableStatic background;
    private final LoadingCache<Integer, IDrawableAnimated> cachedFlames;

    public GeneratorRecipeCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 18, 34).addPadding(0, 0, 0, 20 + Minecraft.getInstance().font.width("Requires Upgrade: Metal Generator")).build();
        this.cachedFlames = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            public IDrawableAnimated load(Integer burnTime) {
                return guiHelper.drawableBuilder(TEXTURE, 0, 37, 13, 13).buildAnimated(burnTime.intValue(), IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    public RecipeType<GeneratorRecipe> getRecipeType() {
        return CrystalToolsRecipeTypes.GENERATOR;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.crystal_tools.category.generator");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GeneratorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setSlotName("Fuel").addItemStack(recipe.stack());
    }

    public void draw(GeneratorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int burnTime = recipe.burnTime();
        IDrawableAnimated flame = (IDrawableAnimated)this.cachedFlames.getUnchecked((Object)burnTime);
        flame.draw(guiGraphics, 3, 19);
        int feGeneration = recipe.bonusGeneration() + (Integer)CrystalToolsConfig.BASE_FE_GENERATION.get();
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MutableComponent burnTimeComponent = Component.literal((String)String.format("Burns for %d ticks", burnTime));
        MutableComponent feComponent = Component.literal((String)String.format("Generates %d FE per tick", feGeneration));
        guiGraphics.drawString(font, (Component)burnTimeComponent, 25, 0, -8355712, false);
        guiGraphics.drawString(font, (Component)feComponent, 25, 10, -8355712, false);
        if (!recipe.upgradeRequired().isEmpty()) {
            MutableComponent upgradeComponent = Component.literal((String)("Requires Upgrade: " + recipe.upgradeRequired()));
            guiGraphics.drawString(font, (Component)upgradeComponent, 25, 20, -12535106, false);
        }
    }
}

