/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.compat.jei.pedestal;

import dev.willyelton.crystal_tools.common.compat.jei.CrystalToolsRecipeTypes;
import dev.willyelton.crystal_tools.common.compat.jei.pedestal.PedestalRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PedestalRecipeCategory
implements IRecipeCategory<PedestalRecipe> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_generator_category.png");
    private final IDrawableStatic background;

    public PedestalRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 18, 18).build();
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 100;
    }

    public RecipeType<PedestalRecipe> getRecipeType() {
        return CrystalToolsRecipeTypes.PEDESTAL;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.crystal_tools.category.pedestal");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PedestalRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setSlotName("Pedestal Item").addItemStack(recipe.stack());
    }

    public void draw(PedestalRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MutableComponent titleComponent = Component.translatable((String)recipe.data().type().name());
        MutableComponent descriptionComponent = Component.translatable((String)recipe.data().type().getDescription());
        guiGraphics.drawString(font, (Component)titleComponent, 25, 0, -16777216, false);
        guiGraphics.drawWordWrap(font, (FormattedText)descriptionComponent, 25, 10, 100, -10461088);
        int y = font.split((FormattedText)descriptionComponent, 100).size() * 9;
        if (recipe.data().params() != null && recipe.data().params().range() > 0) {
            guiGraphics.drawString(font, (Component)Component.literal((String)("Range: +" + recipe.data().params().range())), 25, 11 + y, -8355585, false);
        }
    }
}

