/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.components;

import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.common.components.EffectData;
import dev.willyelton.crystal_tools.common.components.FurnaceData;
import dev.willyelton.crystal_tools.common.components.FurnaceUpgrades;
import dev.willyelton.crystal_tools.common.components.GeneratorData;
import dev.willyelton.crystal_tools.common.components.GeneratorUpgrades;
import dev.willyelton.crystal_tools.common.components.LevelableBlockEntityData;
import dev.willyelton.crystal_tools.common.components.QuarryData;
import dev.willyelton.crystal_tools.common.components.QuarrySettings;
import dev.willyelton.crystal_tools.common.components.QuarryUpgrades;
import dev.willyelton.crystal_tools.common.datamap.GeneratorFuelData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DataComponents {
    public static final DeferredRegister<DataComponentType<?>> COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"crystal_tools");
    public static final Map<String, ResourceLocation> INT_COMPONENTS = new HashMap<String, ResourceLocation>();
    public static final Map<String, ResourceLocation> FLOAT_COMPONENTS = new HashMap<String, ResourceLocation>();
    public static final Map<String, ResourceLocation> BOOLEAN_COMPONENTS = new HashMap<String, ResourceLocation>();
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> SKILL_POINTS = DataComponents.register("skill_points", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> SKILL_EXPERIENCE = DataComponents.register("skill_experience", Codec.INT, ByteBufCodecs.VAR_INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> EXPERIENCE_CAP = DataComponents.register("experience_cap", Codec.INT, ByteBufCodecs.VAR_INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<Integer>>> POINTS_ARRAY = COMPONENTS.register("points", () -> DataComponentType.builder().persistent(Codec.INT.listOf()).networkSynchronized(ByteBufCodecs.INT.apply(ByteBufCodecs.list())).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> REACH = DataComponents.register("reach", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> DURABILITY_BONUS = DataComponents.register("durability_bonus", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> UNBREAKING = DataComponents.register("unbreaking", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> TORCH = DataComponents.register("torch", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> MINING_SPEED = DataComponents.register("speed_bonus", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> AUTO_PICKUP = DataComponents.register("auto_pickup", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> AUTO_SMELT = DataComponents.register("auto_smelt", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DISABLE_AUTO_SMELT = DataComponents.register("disable_auto_smelt", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> VEIN_MINER = DataComponents.register("vein_miner", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> HAS_3x3 = DataComponents.register("3x3", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DISABLE_3x3 = DataComponents.register("disable_3x3", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> MINE_MODE = DataComponents.register("mine_mode", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SILK_TOUCH_BONUS = DataComponents.register("silk_touch_bonus", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FORTUNE_BONUS = DataComponents.register("fortune_bonus", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> AUTO_REPAIR = DataComponents.register("auto_repair", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> AUTO_REPAIR_COUNTER = DataComponents.register("auto_repair_counter", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Long>> AUTO_REPAIR_GAME_TIME = DataComponents.register("auto_repair_game_time", Codec.LONG, ByteBufCodecs.VAR_LONG);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> LEAF_MINE = DataComponents.register("leaf_mine", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SHEAR = DataComponents.register("shear", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> USE_MODE = DataComponents.register("use_mode", Codec.STRING, ByteBufCodecs.STRING_UTF8);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> DAMAGE_BONUS = DataComponents.register("damage_bonus", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> ATTACK_SPEED = DataComponents.register("attack_speed_bonus", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> KNOCKBACK = DataComponents.register("knockback", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> KNOCKBACK_RESISTANCE = DataComponents.register("knockback_resistance", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> FIRE = DataComponents.register("fire", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> LIFESTEAL = DataComponents.register("lifesteal", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> BEHEADING = DataComponents.register("beheading", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> CAPTURING = DataComponents.register("capture", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> HEALTH_BONUS = DataComponents.register("health_bonus", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> SPEED_BONUS = DataComponents.register("move_speed_bonus", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> ARMOR_BONUS = DataComponents.register("armor_bonus", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> TOUGHNESS_BONUS = DataComponents.register("toughness_bonus", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> NIGHT_VISION = DataComponents.register("night_vision", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DISABLE_NIGHT_VISION = DataComponents.register("disable_night_vision", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> NO_FALL_DAMAGE = DataComponents.register("no_fall_damage", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> CREATIVE_FLIGHT = DataComponents.register("creative_flight", Codec.INT, ByteBufCodecs.INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DISABLE_CREATIVE_FLIGHT = DataComponents.register("disable_creative_flight", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> FROST_WALKER = DataComponents.register("frost_walker", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> INFINITY = DataComponents.register("infinity", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> ARROW_DAMAGE = DataComponents.register("arrow_damage", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> ARROW_SPEED = DataComponents.register("arrow_speed_bonus", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> FLAME = DataComponents.register("flame", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> DRAW_SPEED = DataComponents.register("draw_speed", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> NUTRITION_BONUS = DataComponents.register("nutrition_bonus", Codec.INT, ByteBufCodecs.INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> SATURATION_BONUS = DataComponents.register("saturation_bonus", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> ALWAYS_EAT = DataComponents.register("always_eat", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> EAT_SPEED_BONUS = DataComponents.register("eat_speed_bonus", Codec.INT, ByteBufCodecs.INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<EffectData>>> EFFECTS = DataComponents.register("effects", EffectData.CODEC.listOf(), EffectData.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FLIGHT_TIME = DataComponents.register("flight_time", Codec.INT, ByteBufCodecs.INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ItemContainerContents>> INVENTORY_OLD = DataComponents.register("inventory", ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ItemContainerContents>>> BACKPACK_INVENTORY = DataComponents.register("backpack_inventory", ItemContainerContents.CODEC.listOf(), ItemContainerContents.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ItemContainerContents>> FILTER_INVENTORY = DataComponents.register("filter_inventory", ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ItemContainerContents>> COMPRESSION_INVENTORY = DataComponents.register("compression_inventory", ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<Integer>>> COMPRESSION_MODES = DataComponents.register("compression_modes", Codec.INT.listOf(), ByteBufCodecs.INT.apply(ByteBufCodecs.list()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> CAPACITY = DataComponents.register("capacity", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FILTER_CAPACITY = DataComponents.register("filter_capacity", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> WHITELIST = DataComponents.register("whitelist", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SORT_ENABLED = DataComponents.register("sort_enabled", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> COMPRESSION_ENABLED = DataComponents.register("compression_enabled", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> BACKPACK_AUTO_PICKUP = DataComponents.register("backpack_auto_pickup", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> PICKUP_DISABLED = DataComponents.register("pickup_disabled", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> INVENTORY_STORE = DataComponents.register("inventory_store", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> RIPTIDE = DataComponents.register("riptide", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> RIPTIDE_DISABLED = DataComponents.register("riptide_disabled", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> ALWAYS_RIPTIDE = DataComponents.register("always_riptide", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> PROJECTILE_SPEED = DataComponents.register("projectile_speed", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> PROJECTILE_DAMAGE = DataComponents.register("projectile_damage", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> LOYALTY = DataComponents.register("loyalty", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> INSTANT_LOYALTY = DataComponents.register("instant_loyalty", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> CHANNELING = DataComponents.register("channeling", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> LURE = DataComponents.register("lure", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> LUCK_OF_THE_SEA = DataComponents.register("luck_of_the_sea", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> DOUBLE_DROPS = DataComponents.register("double_drops", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<LevelableBlockEntityData>> LEVELABLE_BLOCK_ENTITY_DATA = DataComponents.register("levelable_block_entity_data", LevelableBlockEntityData.CODEC, LevelableBlockEntityData.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<FurnaceData>> FURNACE_DATA = DataComponents.register("furnace_data", FurnaceData.CODEC, FurnaceData.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<FurnaceUpgrades>> FURNACE_UPGRADES = DataComponents.register("furnace_upgrades", FurnaceUpgrades.CODEC, FurnaceUpgrades.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ItemContainerContents>> FURNACE_INVENTORY = DataComponents.register("furnace_inventory", ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<GeneratorData>> GENERATOR_DATA = DataComponents.register("generator_data", GeneratorData.CODEC, GeneratorData.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<GeneratorUpgrades>> GENERATOR_UPGRADES = DataComponents.register("generator_upgrades", GeneratorUpgrades.CODEC, GeneratorUpgrades.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<BlockPos>>> QUARRY_BOUNDS = DataComponents.register("quarry_bounds", BlockPos.CODEC.listOf(), BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<QuarryData>> QUARRY_DATA = DataComponents.register("quarry_data", QuarryData.CODEC, QuarryData.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<QuarryUpgrades>> QUARRY_UPGRADES = DataComponents.register("quarry_upgrades", QuarryUpgrades.CODEC, QuarryUpgrades.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<QuarrySettings>> QUARRY_SETTINGS = DataComponents.register("quarry_settings", QuarrySettings.CODEC, QuarrySettings.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ItemContainerContents>> QUARRY_FILTER = DataComponents.register("quarry_filter", ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> AUTO_OUTPUT = DataComponents.register("auto_output", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> CHUNKLOADING = DataComponents.register("chunkloading", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> AUTO_TARGET = DataComponents.register("auto_target", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> ENTITY_TARGET = DataComponents.register("entity_target", Codec.INT, ByteBufCodecs.VAR_INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DISABLE_AUTO_TARGET = DataComponents.register("disable_auto_target", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> FLAMING_SHIELD = DataComponents.register("flaming_shield", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> SHIELD_THORNS = DataComponents.register("shield_thorns", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> SHIELD_KNOCKBACK = DataComponents.register("shield_knockback", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> TOTEM_SLOTS = DataComponents.register("totem_slots", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FILLED_TOTEM_SLOTS = DataComponents.register("filled_totem_slots", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> BLOCK_COOLDOWN_REDUCTION = DataComponents.register("block_cooldown_reduction", Codec.INT, ByteBufCodecs.VAR_INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DISABLED = DataComponents.register("disabled", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> ITEM_SPEED = DataComponents.register("item_speed", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> MAGNET_RANGE = DataComponents.register("magnet_range", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> PULL_XP = DataComponents.register("pull_xp", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> PULL_MOBS = DataComponents.register("pull_mobs", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> INSTANT_PICKUP = DataComponents.register("instant_pickup", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DISABLE_MOB_PULL = DataComponents.register("disable_mob_pull", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FE_GENERATION = DataComponents.register("fe_generation", Codec.INT, ByteBufCodecs.INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Float>> FUEL_EFFICIENCY = DataComponents.register("fuel_efficiency", Codec.FLOAT, ByteBufCodecs.FLOAT, SkillType.FLOAT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FE_CAPACITY = DataComponents.register("fe_capacity", Codec.INT, ByteBufCodecs.INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FE_STORED = DataComponents.register("fe_stored", Codec.INT, ByteBufCodecs.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> METAL_GENERATOR = DataComponents.register("metal_generator", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> FOOD_GENERATOR = DataComponents.register("food_generator", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> GEM_GENERATOR = DataComponents.register("gem_generator", Codec.BOOL, ByteBufCodecs.BOOL, SkillType.BOOLEAN);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<GeneratorFuelData>> BURNING_ITEM_DATA = DataComponents.register("burning_item_data", GeneratorFuelData.CODEC, GeneratorFuelData.STREAM_CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> PORTABLE_GENERATOR_SLOTS = DataComponents.register("portable_generator_slots", Codec.INT, ByteBufCodecs.INT, SkillType.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> MAX_BURN_TIME = DataComponents.register("max_burn_time", Codec.INT, ByteBufCodecs.INT);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> GENERATED_LAST_TICK = DataComponents.register("generated_last_tick", Codec.INT, ByteBufCodecs.INT);

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String key, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        return DataComponents.register(key, codec, streamCodec, SkillType.NONE);
    }

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String key, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, SkillType skillType) {
        DeferredHolder result = streamCodec == null ? COMPONENTS.register(key, () -> DataComponentType.builder().persistent(codec).build()) : COMPONENTS.register(key, () -> DataComponentType.builder().persistent(codec).networkSynchronized(streamCodec).build());
        switch (skillType.ordinal()) {
            case 0: {
                INT_COMPONENTS.put(key, result.getId());
                break;
            }
            case 1: {
                FLOAT_COMPONENTS.put(key, result.getId());
                break;
            }
            case 2: {
                BOOLEAN_COMPONENTS.put(key, result.getId());
            }
        }
        return result;
    }

    public static float addToComponent(ItemStack stack, DeferredHolder<DataComponentType<?>, DataComponentType<Float>> component, float f) {
        float newValue = ((Float)stack.getOrDefault(component, (Object)Float.valueOf(0.0f))).floatValue() + f;
        stack.set(component, (Object)Float.valueOf(newValue));
        return newValue;
    }

    public static int addToComponent(ItemStack stack, DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> component, int i) {
        int newValue = (Integer)stack.getOrDefault(component, (Object)0) + i;
        stack.set(component, (Object)newValue);
        return newValue;
    }

    public static void addToComponent(ItemStack stack, String componentKey, float value) {
        DataComponentType dataComponent;
        ResourceLocation resourceLocation = FLOAT_COMPONENTS.get(componentKey);
        if (resourceLocation != null && (dataComponent = (DataComponentType)((Registry)COMPONENTS.getRegistry().get()).get(resourceLocation)) != null) {
            stack.set(dataComponent, (Object)Float.valueOf(((Float)stack.getOrDefault(dataComponent, (Object)Float.valueOf(0.0f))).floatValue() + value));
            return;
        }
        resourceLocation = INT_COMPONENTS.get(componentKey);
        if (resourceLocation != null && (dataComponent = (DataComponentType)((Registry)COMPONENTS.getRegistry().get()).get(resourceLocation)) != null) {
            stack.set(dataComponent, (Object)((Integer)stack.getOrDefault(dataComponent, (Object)0) + (int)value));
            return;
        }
        resourceLocation = BOOLEAN_COMPONENTS.get(componentKey);
        if (resourceLocation != null && (dataComponent = (DataComponentType)((Registry)COMPONENTS.getRegistry().get()).get(resourceLocation)) != null && value > 0.0f) {
            stack.set(dataComponent, (Object)true);
            return;
        }
        throw new IllegalArgumentException("Skill " + componentKey + " not registered correctly");
    }

    public static void setValue(ItemStack stack, String componentKey, float value) {
        DataComponentType dataComponent;
        ResourceLocation resourceLocation = FLOAT_COMPONENTS.get(componentKey);
        if (resourceLocation != null && (dataComponent = (DataComponentType)((Registry)COMPONENTS.getRegistry().get()).get(resourceLocation)) != null) {
            stack.set(dataComponent, (Object)Float.valueOf(value));
            return;
        }
        resourceLocation = INT_COMPONENTS.get(componentKey);
        if (resourceLocation != null && (dataComponent = (DataComponentType)((Registry)COMPONENTS.getRegistry().get()).get(resourceLocation)) != null) {
            stack.set(dataComponent, (Object)((int)value));
            return;
        }
        resourceLocation = BOOLEAN_COMPONENTS.get(componentKey);
        if (resourceLocation != null && (dataComponent = (DataComponentType)((Registry)COMPONENTS.getRegistry().get()).get(resourceLocation)) != null) {
            stack.set(dataComponent, (Object)(value > 0.0f ? 1 : 0));
            return;
        }
        throw new IllegalArgumentException("Skill " + componentKey + " not registered correctly");
    }

    public static void addValueToArray(ItemStack stack, DeferredHolder<DataComponentType<?>, DataComponentType<List<Integer>>> component, int index, int value) {
        ArrayList<Integer> points = new ArrayList<Integer>((Collection)stack.getOrDefault(component, new ArrayList()));
        if (points.size() > index) {
            points.set(index, (Integer)points.get(index) + value);
        } else {
            while (points.size() < index) {
                points.add(0);
            }
            points.add(value);
        }
        stack.set(component, points);
    }

    private static enum SkillType {
        INT,
        FLOAT,
        BOOLEAN,
        NONE;

    }
}

