/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record QuarryData(BlockPos miningAt, float currentProgress, BlockState miningState, boolean finished, List<ItemStack> waitingStacks, int currentEnergy, boolean whitelist) {
    public static final Codec<QuarryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("miningAt").forGetter(QuarryData::miningAt), (App)Codec.FLOAT.fieldOf("currentProgress").forGetter(QuarryData::currentProgress), (App)BlockState.CODEC.optionalFieldOf("miningState").xmap(o -> o.orElse(Blocks.AIR.defaultBlockState()), Optional::ofNullable).forGetter(QuarryData::miningState), (App)Codec.BOOL.fieldOf("finished").forGetter(QuarryData::finished), (App)ItemStack.CODEC.listOf().fieldOf("waitingStacks").forGetter(QuarryData::waitingStacks), (App)Codec.INT.fieldOf("currentEnergy").forGetter(QuarryData::currentEnergy), (App)Codec.BOOL.fieldOf("whitelist").forGetter(QuarryData::whitelist)).apply((Applicative)instance, QuarryData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, QuarryData> STREAM_CODEC = NeoForgeStreamCodecs.composite((StreamCodec)BlockPos.STREAM_CODEC, QuarryData::miningAt, (StreamCodec)ByteBufCodecs.FLOAT, QuarryData::currentProgress, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY)).map(blockState -> blockState.orElse(Blocks.AIR.defaultBlockState()), Optional::ofNullable), QuarryData::miningState, (StreamCodec)ByteBufCodecs.BOOL, QuarryData::finished, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), QuarryData::waitingStacks, (StreamCodec)ByteBufCodecs.INT, QuarryData::currentEnergy, (StreamCodec)ByteBufCodecs.BOOL, QuarryData::whitelist, QuarryData::new);
}

