/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.crafting;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.crafting.CrystalToolsRecipe;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.utils.ArrayUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrystalAIOTRecipe
extends CrystalToolsRecipe {
    private static final Item[] requiredItems = new Item[]{(Item)Registration.CRYSTAL_AXE.get(), (Item)Registration.CRYSTAL_PICKAXE.get(), (Item)Registration.CRYSTAL_SHOVEL.get(), (Item)Registration.CRYSTAL_HOE.get(), (Item)Registration.CRYSTAL_SWORD.get(), Items.SLIME_BLOCK};

    public CrystalAIOTRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, @NotNull Level level) {
        if (((Boolean)CrystalToolsConfig.DISABLE_AIOT.get()).booleanValue()) {
            return false;
        }
        Object[] itemsFound = new Boolean[requiredItems.length];
        Arrays.fill(itemsFound, (Object)false);
        for (int i = 0; i < container.size(); ++i) {
            ItemStack itemStack = container.getItem(i);
            boolean foundItem = false;
            for (int j = 0; j < requiredItems.length; ++j) {
                if (!itemStack.is(requiredItems[j])) continue;
                if (((Boolean)itemsFound[j]).booleanValue()) {
                    return false;
                }
                itemsFound[j] = true;
                foundItem = true;
            }
            if (foundItem || itemStack.isEmpty()) continue;
            return false;
        }
        return ArrayUtils.indexOf(itemsFound, false) == -1;
    }

    @NotNull
    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registryAccess) {
        ItemStack result = new ItemStack((ItemLike)Registration.CRYSTAL_AIOT.get());
        List<ItemStack> levelableItems = this.getLevelableItems(container);
        int totalPoints = 0;
        for (ItemStack stack : levelableItems) {
            totalPoints += this.getPoints(stack);
        }
        result.set(DataComponents.SKILL_POINTS, (Object)totalPoints);
        ToolUtils.increaseExpCap(result, totalPoints);
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 6;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registration.CRYSTAL_AIOT_RECIPE.get();
    }

    private List<ItemStack> getLevelableItems(CraftingInput container) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (!(stack.getItem() instanceof LevelableItem)) continue;
            result.add(stack);
        }
        return result;
    }

    @Override
    public List<ItemStack> getInputs() {
        return Arrays.stream(requiredItems).map(ItemStack::new).toList();
    }

    @Override
    public ItemStack getOutput() {
        return new ItemStack((ItemLike)Registration.CRYSTAL_AIOT.get());
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)Registration.CRYSTAL_AIOT.get());
    }
}

