/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.crafting;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.LevelableBlockEntityData;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.crafting.CrystalToolsRecipe;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrystalQuarryRecipe
extends CrystalToolsRecipe {
    public CrystalQuarryRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.width() != 3 || input.height() != 3) {
            return false;
        }
        List<ItemStack> inputs = this.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            if (input.getItem(i % 3, i / 3).is(inputs.get(i).getItem())) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack result = new ItemStack(Registration.CRYSTAL_QUARRY_ITEM);
        ItemStack aiotItem = input.getItem(1, 1);
        int points = (int)((double)this.getPoints(aiotItem) * (Double)CrystalToolsConfig.QUARRY_INITIAL_POINT_MULTIPLIER.get());
        int cap = ToolUtils.getNewCap((Integer)CrystalToolsConfig.QUARRY_BASE_EXPERIENCE_CAP.get(), points);
        LevelableBlockEntityData skillData = new LevelableBlockEntityData(points, cap);
        result.set(DataComponents.LEVELABLE_BLOCK_ENTITY_DATA, (Object)skillData);
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width == 3 && height == 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registration.CRYSTAL_QUARRY_RECIPE.get();
    }

    @Override
    public List<ItemStack> getInputs() {
        return Stream.of((Item)Registration.CRYSTAL_BLOCK_ITEM.get(), (Item)Registration.CRYSTAL.get(), (Item)Registration.CRYSTAL_BLOCK_ITEM.get(), (Item)Registration.CRYSTAL.get(), (Item)Registration.CRYSTAL_AIOT.get(), (Item)Registration.CRYSTAL.get(), Items.NETHERITE_INGOT, Items.NETHERITE_INGOT, Items.NETHERITE_INGOT).map(ItemStack::new).toList();
    }

    @Override
    public ItemStack getOutput() {
        ItemStack output = new ItemStack((ItemLike)Registration.CRYSTAL_QUARRY_ITEM.get());
        output.set(net.minecraft.core.component.DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)String.format("Will take %d%% of the points from the AIOT used to craft this.", (int)((Double)CrystalToolsConfig.QUARRY_INITIAL_POINT_MULTIPLIER.get() * 100.0))))));
        return output;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)Registration.CRYSTAL_QUARRY.get());
    }
}

