/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class ItemDisabledCondition
implements ICondition {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"item_disabled");
    public static final MapCodec<? extends ICondition> ITEM_DISABLED_CODEC = MapCodec.assumeMapUnsafe((Codec)RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("itemLocation").forGetter(ItemDisabledCondition::getItemLocation)).apply((Applicative)instance, ItemDisabledCondition::new)));
    private final ResourceLocation itemLocation;

    public ItemDisabledCondition(ResourceLocation item) {
        this.itemLocation = item;
    }

    public boolean test(ICondition.IContext context) {
        Item item = (Item)BuiltInRegistries.ITEM.get(this.itemLocation);
        if (item instanceof LevelableItem) {
            LevelableItem levelableItem = (LevelableItem)item;
            return levelableItem.isDisabled();
        }
        return false;
    }

    @NotNull
    public MapCodec<? extends ICondition> codec() {
        return ITEM_DISABLED_CODEC;
    }

    public ResourceLocation getItemLocation() {
        return this.itemLocation;
    }
}

