/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.entity;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.tool.CrystalTrident;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CrystalTridentEntity
extends AbstractArrow {
    public static final String CRYSTAL_TOOLS_TRIDENT_LIGHTNING_TAG = "crystal_tools.trident.lightning";
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(CrystalTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected ItemStack tridentStack = new ItemStack((ItemLike)Registration.CRYSTAL_TRIDENT.get());
    protected CrystalTrident tridentItem = (CrystalTrident)Registration.CRYSTAL_TRIDENT.get();
    protected boolean dealtDamage;
    protected int clientSideReturnTridentTickCount;

    public CrystalTridentEntity(EntityType<? extends CrystalTridentEntity> entityType, Level level) {
        super(entityType, level);
    }

    public CrystalTridentEntity(Level level, LivingEntity shooter, ItemStack stack) {
        super((EntityType)Registration.CRYSTAL_TRIDENT_ENTITY.get(), shooter, level, stack, null);
        this.tridentStack = stack;
        this.entityData.set(ID_LOYALTY, (Object)((Integer)stack.getOrDefault(DataComponents.LOYALTY, (Object)0)).byteValue());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_LOYALTY, (Object)0);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte loyaltyLevel = (Byte)this.entityData.get(ID_LOYALTY);
        if (loyaltyLevel > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptableReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                Player player;
                if (((Boolean)this.tridentStack.getOrDefault(DataComponents.INSTANT_LOYALTY, (Object)false)).booleanValue() && entity instanceof Player && (player = (Player)entity).getInventory().add(this.getPickupItem())) {
                    this.discard();
                }
                this.setNoPhysics(true);
                Vec3 moveDirection = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + moveDirection.y * 0.015 * (double)loyaltyLevel, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)loyaltyLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(moveDirection.normalize().scale(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    protected ItemStack getPickupItem() {
        return this.tridentStack.copy();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Registration.CRYSTAL_TRIDENT.get());
    }

    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.findHitEntity(pStartVec, pEndVec);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity hitEntity = result.getEntity();
        float damage = 8.0f + ((Float)this.tridentStack.getOrDefault(DataComponents.PROJECTILE_DAMAGE, (Object)Float.valueOf(0.0f))).floatValue();
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(this.getOwner() == null ? this : this.getOwner()));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            damage += EnchantmentHelper.modifyDamage((ServerLevel)level2, (ItemStack)this.tridentStack, (Entity)hitEntity, (DamageSource)damagesource, (float)damage);
        }
        Entity damagingEntity = this.getOwner();
        this.dealtDamage = true;
        if (hitEntity.hurt(damagesource, damage)) {
            if (hitEntity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (hitEntity instanceof LivingEntity) {
                Level level3;
                LivingEntity livingEntity = (LivingEntity)hitEntity;
                if (damagingEntity instanceof LivingEntity && (level3 = this.level()) instanceof ServerLevel) {
                    ServerLevel level4 = (ServerLevel)level3;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)level4, (Entity)livingEntity, (DamageSource)damagesource, (ItemStack)this.tridentStack);
                }
                this.doPostHurtEffects(livingEntity);
            }
            if (damagingEntity instanceof Player) {
                Player player = (Player)damagingEntity;
                this.tridentItem.addExp(this.tridentStack, this.level(), damagingEntity.getOnPos(), (LivingEntity)player, (int)damage);
            }
        }
        if (!this.summonLightning(hitEntity.blockPosition())) {
            this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
    }

    protected void onHitBlock(BlockHitResult result) {
        if (((Boolean)CrystalToolsConfig.ALWAYS_CHANNEL.get()).booleanValue()) {
            this.summonLightning(result.getBlockPos());
        }
        super.onHitBlock(result);
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player entity) {
        if (this.ownedBy((Entity)entity) || this.getOwner() == null) {
            super.playerTouch(entity);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.dealtDamage = pCompound.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, (Object)((Integer)this.tridentStack.getOrDefault(DataComponents.LOYALTY, (Object)0)).byteValue());
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("DealtDamage", this.dealtDamage);
    }

    public void tickDespawn() {
        byte loyaltyLevel = (Byte)this.entityData.get(ID_LOYALTY);
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || loyaltyLevel <= 0) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double pX, double pY, double pZ) {
        return true;
    }

    private boolean isChanneling() {
        return (Integer)this.tridentStack.getOrDefault(DataComponents.CHANNELING, (Object)0) > 0;
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    private boolean summonLightning(BlockPos blockPos) {
        if (!this.level().isClientSide && this.isChanneling()) {
            LightningBolt lightningbolt;
            blockPos = blockPos.above();
            if (this.level().canSeeSky(blockPos) && (lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level())) != null) {
                int damage = 5 + (Integer)this.tridentStack.getOrDefault(DataComponents.CHANNELING, (Object)0);
                lightningbolt.setDamage((float)damage);
                lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)blockPos));
                lightningbolt.setCause(this.getOwner() instanceof ServerPlayer ? (ServerPlayer)this.getOwner() : null);
                lightningbolt.addTag(CRYSTAL_TOOLS_TRIDENT_LIGHTNING_TAG);
                this.level().addFreshEntity((Entity)lightningbolt);
                this.playSound((SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), 5.0f, 1.0f);
                return true;
            }
        }
        return false;
    }
}

