/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.CrystalBackpack;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="crystal_tools")
public class BlockEvents {
    @SubscribeEvent
    public static void breakEvent(BlockEvent.BreakEvent event) {
        CrystalBackpack.addXpToBackpacks(event.getPlayer(), 1);
    }

    @SubscribeEvent
    public static void dropEvent(BlockDropsEvent event) {
        ItemStack tool = event.getTool();
        if (tool.isEmpty()) {
            return;
        }
        Entity entity = event.getBreaker();
        ServerLevel level = event.getLevel();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            List drops = event.getDrops();
            if (((Boolean)tool.getOrDefault(DataComponents.AUTO_SMELT, (Object)false)).booleanValue() && !((Boolean)tool.getOrDefault(DataComponents.DISABLE_AUTO_SMELT, (Object)false)).booleanValue()) {
                for (ItemEntity item : drops) {
                    ItemStack stack = item.getItem();
                    Optional recipeOptional = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)level);
                    if (!recipeOptional.isPresent()) continue;
                    SmeltingRecipe recipe = (SmeltingRecipe)((RecipeHolder)recipeOptional.get()).value();
                    BlockEvents.popExperience(level, (LivingEntity)player, recipe.getExperience());
                    ItemStack result = recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                    result.setCount(stack.getCount() * result.getCount());
                    if (result.is(Items.AIR)) continue;
                    item.setItem(result);
                }
            }
            if (((Boolean)tool.getOrDefault(DataComponents.AUTO_PICKUP, (Object)false)).booleanValue()) {
                boolean pickedUp = false;
                for (ItemEntity item : drops) {
                    ItemStack stack = item.getItem();
                    if (!player.getInventory().add(stack)) {
                        item.setItem(stack);
                        continue;
                    }
                    pickedUp = true;
                }
                if (pickedUp) {
                    player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)SoundEvents.ITEM_PICKUP), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 0.2f, (level.random.nextFloat() - level.random.nextFloat()) * 1.4f + 2.0f, level.getRandom().nextLong()));
                }
            }
        }
    }

    private static void popExperience(ServerLevel level, LivingEntity entity, float experience) {
        int fullXp = (int)Math.floor(experience);
        float partialXp = experience - (float)fullXp;
        if (partialXp > 0.0f && Math.random() < (double)partialXp) {
            ExperienceOrb.award((ServerLevel)level, (Vec3)entity.position(), (int)(fullXp + 1));
        } else {
            ExperienceOrb.award((ServerLevel)level, (Vec3)entity.position(), (int)fullXp);
        }
    }
}

