/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.tool.CrystalFishingRod;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="crystal_tools")
public class ItemFishedEvent {
    @SubscribeEvent
    public static void handleItemFishedEvent(net.neoforged.neoforge.event.entity.player.ItemFishedEvent event) {
        ItemStack rodStack;
        Player player = event.getEntity();
        FishingHook hook = event.getHookEntity();
        if (player.getMainHandItem().is((Item)Registration.CRYSTAL_FISHING_ROD.get()) && hook.getTags().contains("crystal_tools.fishing.main")) {
            rodStack = player.getMainHandItem();
        } else if (player.getOffhandItem().is((Item)Registration.CRYSTAL_FISHING_ROD.get()) && hook.getTags().contains("crystal_tools.fishing.off")) {
            rodStack = player.getOffhandItem();
        } else {
            return;
        }
        CrystalFishingRod rodItem = (CrystalFishingRod)rodStack.getItem();
        if (!rodStack.isEmpty()) {
            if (((Float)rodStack.getOrDefault(DataComponents.DOUBLE_DROPS, (Object)Float.valueOf(0.0f))).floatValue() > player.level().getRandom().nextFloat()) {
                List<ItemStack> copiedDrops = event.getDrops().stream().map(ItemStack::copy).toList();
                CrystalFishingRod.dropExtraItems(copiedDrops, player, hook);
            }
            rodItem.addExp(rodStack, player.level(), player.getOnPos(), (LivingEntity)player, (Integer)CrystalToolsConfig.FISHING_ROD_EXP.get());
        }
    }
}

