/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.datamap.DataMaps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="crystal_tools")
public class LivingDeathEvent {
    @SubscribeEvent
    public static void handle(net.neoforged.neoforge.event.entity.living.LivingDeathEvent event) {
        Level level;
        ItemStack weaponStack;
        LivingEntity deadEntity = event.getEntity();
        if (event.getSource().getEntity() != null && (weaponStack = event.getSource().getEntity().getWeaponItem()) != null && (level = deadEntity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Number)weaponStack.getOrDefault(DataComponents.BEHEADING, (Object)0)).floatValue() > serverLevel.getRandom().nextFloat()) {
                Item skullItem = (Item)deadEntity.getType().builtInRegistryHolder().getData(DataMaps.MOB_SKULLS);
                LivingDeathEvent.spawnItem(serverLevel, (Entity)deadEntity, skullItem);
            }
            if (((Number)weaponStack.getOrDefault(DataComponents.CAPTURING, (Object)0)).floatValue() > serverLevel.getRandom().nextFloat()) {
                SpawnEggItem spawnEggItem = SpawnEggItem.byId((EntityType)deadEntity.getType());
                LivingDeathEvent.spawnItem(serverLevel, (Entity)deadEntity, (Item)spawnEggItem);
            }
        }
    }

    private static void spawnItem(ServerLevel level, Entity entity, Item item) {
        if (item != null) {
            level.addFreshEntity((Entity)new ItemEntity((Level)level, entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)item)));
        }
    }
}

