/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

@EventBusSubscriber(modid="crystal_tools")
public class ProjectileHitEvent {
    @SubscribeEvent
    public static void handleProjectileHit(ProjectileImpactEvent event) {
        Entity owner = event.getProjectile().getOwner();
        if (owner instanceof Player) {
            Projectile projectile;
            ItemStack heldItem;
            LivingEntity target;
            EntityHitResult hitResult;
            Entity entity;
            HitResult hitResult2;
            Player player = (Player)owner;
            if (event.getRayTraceResult().getType() == HitResult.Type.ENTITY && (hitResult2 = event.getRayTraceResult()) instanceof EntityHitResult && (entity = (hitResult = (EntityHitResult)hitResult2).getEntity()) instanceof LivingEntity && ToolUtils.isValidEntity(target = (LivingEntity)entity) && (heldItem = player.getMainHandItem()).is((Item)Registration.CRYSTAL_BOW.get()) && (projectile = event.getProjectile()) instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                float f = (float)arrow.getDeltaMovement().length();
                int damage = Mth.ceil((double)Mth.clamp((double)((double)f * arrow.getBaseDamage()), (double)0.0, (double)2.147483647E9));
                LevelableItem item = (LevelableItem)Registration.CRYSTAL_BOW.get();
                item.addExp(heldItem, player.level(), player.getOnPos(), (LivingEntity)player, (int)((double)damage * (Double)CrystalToolsConfig.BOW_EXPERIENCE_BOOST.get()));
            }
        }
    }
}

