/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.energy.CrystalEnergyStorage;
import dev.willyelton.crystal_tools.common.inventory.CrystalBackpackInventory;
import dev.willyelton.crystal_tools.common.inventory.PortableGeneratorInventory;
import dev.willyelton.crystal_tools.common.levelable.PortableGenerator;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalFurnaceBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalGeneratorBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalPedestalBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalQuarryBlockEntity;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;

@EventBusSubscriber(modid="crystal_tools", bus=EventBusSubscriber.Bus.MOD)
public class RegisterCapabilitiesEvent {
    @SubscribeEvent
    public static void onRegisterCapabilities(net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> {
            ItemContainerContents contents;
            if (stack.has(DataComponents.INVENTORY_OLD) && (contents = (ItemContainerContents)stack.get(DataComponents.INVENTORY_OLD)) != null) {
                stack.remove(DataComponents.INVENTORY_OLD);
                stack.set(DataComponents.BACKPACK_INVENTORY, List.of(contents));
            }
            return new CrystalBackpackInventory((ItemStack)stack);
        }, new ItemLike[]{(ItemLike)Registration.CRYSTAL_BACKPACK.get()});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> new PortableGeneratorInventory((ItemStack)stack), new ItemLike[]{(ItemLike)Registration.PORTABLE_GENERATOR.get()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new CrystalEnergyStorage(PortableGenerator.getCapacity(stack), 0, 40, PortableGenerator.getEnergy(stack)), new ItemLike[]{(ItemLike)Registration.PORTABLE_GENERATOR.get()});
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Registration.CRYSTAL_FURNACE_BLOCK_ENTITY.get(), CrystalFurnaceBlockEntity::getCapForSide);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Registration.CRYSTAL_GENERATOR_BLOCK_ENTITY.get(), CrystalGeneratorBlockEntity::getItemHandlerCapForSide);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)Registration.CRYSTAL_GENERATOR_BLOCK_ENTITY.get(), CrystalGeneratorBlockEntity::getEnergyStorageCapForSide);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Registration.CRYSTAL_QUARRY_BLOCK_ENTITY.get(), CrystalQuarryBlockEntity::getItemHandlerCapForSide);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)Registration.CRYSTAL_QUARRY_BLOCK_ENTITY.get(), CrystalQuarryBlockEntity::getEnergyStorageCapForSide);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Registration.CRYSTAL_PEDESTAL_BLOCK_ENTITY.get(), CrystalPedestalBlockEntity::getItemHandlerCapForSide);
    }
}

