/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.network.data.SkillCacheUpdatePayload;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="crystal_tools")
public class ReloadListenerEvent {
    private static final Gson gson = new GsonBuilder().create();
    private static final List<String> SKILL_TREES = List.of("aiot", "apple", "axe", "boots", "bow", "chestplate", "crystal_elytra", "crystal_furnace", "crystal_rocket", "helmet", "hoe", "leggings", "pickaxe", "shovel", "sword", "backpack", "trident", "fishing_rod", "generator", "quarry", "shield", "magnet", "portable_generator");
    private static Map<String, SkillData> skillDataMap;

    @SubscribeEvent
    public static void handleReloadListener(AddReloadListenerEvent reloadListenerEvent) {
        reloadListenerEvent.addListener((PreparableReloadListener)new ReloadListener());
    }

    @SubscribeEvent
    public static void handleDataPackSync(OnDatapackSyncEvent onDatapackSyncEvent) {
        for (Map.Entry<String, SkillData> entry : skillDataMap.entrySet()) {
            if (onDatapackSyncEvent.getPlayer() != null) {
                CrystalTools.LOGGER.log(Level.TRACE, "Syncing Tool {} with player {}", (Object)entry.getKey(), (Object)onDatapackSyncEvent.getPlayer().getDisplayName().getString());
                PacketDistributor.sendToPlayer((ServerPlayer)onDatapackSyncEvent.getPlayer(), (CustomPacketPayload)new SkillCacheUpdatePayload(entry.getKey(), entry.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                continue;
            }
            CrystalTools.LOGGER.log(Level.TRACE, "Syncing Tool {} with all players", (Object)entry.getKey());
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SkillCacheUpdatePayload(entry.getKey(), entry.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static final class ReloadListener
    extends SimplePreparableReloadListener<Map<String, SkillData>> {
        private ReloadListener() {
        }

        @NotNull
        protected Map<String, SkillData> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            CrystalTools.LOGGER.log(Level.TRACE, "Reloading Crystal Tools Skill Trees");
            HashMap<String, SkillData> result = new HashMap<String, SkillData>();
            for (String tool : SKILL_TREES) {
                SkillData skillTree = this.deserializeSkillData(tool, resourceManager);
                if (skillTree == null) continue;
                result.put(tool, skillTree);
            }
            return result;
        }

        protected void apply(@NotNull Map<String, SkillData> skillDataMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            CrystalTools.LOGGER.log(Level.TRACE, "Populating Crystal Tools Skill Data Cache");
            ReloadListenerEvent.skillDataMap = skillDataMap;
        }

        private SkillData deserializeSkillData(String tool, ResourceManager resourceManager) {
            try {
                Resource resource;
                BufferedReader reader;
                DataResult result;
                Optional resourceOptional = resourceManager.getResource(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)("skill_trees/" + tool + ".json")));
                if (resourceOptional.isPresent() && (result = SkillData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)gson.fromJson((Reader)(reader = new BufferedReader(new InputStreamReader((resource = (Resource)resourceOptional.get()).open()))), JsonElement.class)))).result().isPresent()) {
                    return (SkillData)result.result().get();
                }
            }
            catch (IOException e) {
                CrystalTools.LOGGER.log(Level.WARN, "Failed to Load Crystal Tools Skill Tree " + tool, (Throwable)e);
            }
            CrystalTools.LOGGER.log(Level.WARN, "Failed to Load Crystal Tools Skill Tree " + tool);
            return null;
        }
    }
}

