/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.inventory.ListComponentItemHandler;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class CrystalBackpackInventory
extends ListComponentItemHandler {
    public CrystalBackpackInventory(int size) {
        super((MutableDataComponentHolder)ItemStack.EMPTY.copy(), (DataComponentType<List<ItemContainerContents>>)((DataComponentType)DataComponents.BACKPACK_INVENTORY.get()), size);
    }

    public CrystalBackpackInventory(ItemStack stack) {
        super((MutableDataComponentHolder)stack, (DataComponentType<List<ItemContainerContents>>)((DataComponentType)DataComponents.BACKPACK_INVENTORY.get()), ((Integer)stack.getOrDefault(DataComponents.CAPACITY, (Object)0) + 1) * 9);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return !stack.is((Item)Registration.CRYSTAL_BACKPACK.get());
    }

    public ItemStack insertStack(ItemStack stack) {
        return ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)stack, (boolean)false);
    }

    public void sort(SortType sortType) {
        List<ItemStack> stacks = this.getAllStacks();
        stacks.sort(this.getComparator(sortType, stacks));
        InventoryUtils.clear(this);
        stacks.forEach(this::insertStack);
    }

    public int getLastStack() {
        for (int i = this.getSlots() - 1; i >= 0; --i) {
            if (this.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private Comparator<ItemStack> getComparator(SortType type, List<ItemStack> stacks) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.quantityComparator(stacks).thenComparing(this.idComparator());
            case 1 -> this.nameComparator().thenComparing(this.idComparator());
            case 2 -> this.modComparator().thenComparing(this.idComparator());
            case 3 -> this.idComparator();
        };
    }

    private List<ItemStack> getAllStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    private Comparator<ItemStack> quantityComparator(List<ItemStack> stacks) {
        Int2IntArrayMap map = new Int2IntArrayMap();
        for (ItemStack stack : stacks) {
            map.merge(this.getItemId(stack), stack.getCount(), Integer::sum);
        }
        return Comparator.comparingInt(arg_0 -> this.lambda$quantityComparator$0((Int2IntMap)map, arg_0)).reversed();
    }

    private Comparator<ItemStack> nameComparator() {
        return Comparator.comparing(this::getItemName);
    }

    private Comparator<ItemStack> modComparator() {
        return Comparator.comparing(this::getItemMod);
    }

    private Comparator<ItemStack> idComparator() {
        return Comparator.comparing(this::getItemId);
    }

    private int getItemQuantity(ItemStack stack, Int2IntMap quantities) {
        return quantities.get(this.getItemId(stack));
    }

    private String getItemName(ItemStack stack) {
        return stack.getDisplayName().getString();
    }

    private String getItemMod(ItemStack stack) {
        return stack.getItem().getCreatorModId(stack);
    }

    private int getItemId(ItemStack stack) {
        return Item.getId((Item)stack.getItem());
    }

    private /* synthetic */ int lambda$quantityComparator$0(Int2IntMap map, ItemStack stack) {
        return this.getItemQuantity(stack, map);
    }

    public static enum SortType {
        QUANTITY,
        NAME,
        MOD,
        ID;

    }
}

