/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ListComponentItemHandler
implements IItemHandlerModifiable {
    private static final int MAX_CONTENTS_SIZE = 256;
    protected final MutableDataComponentHolder parent;
    protected final DataComponentType<List<ItemContainerContents>> component;
    protected final int size;

    public ListComponentItemHandler(MutableDataComponentHolder parent, DataComponentType<List<ItemContainerContents>> component, int size) {
        this.parent = parent;
        this.component = component;
        this.size = size;
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack getStackInSlot(int slot) {
        ItemContainerContents contents = this.getContents(slot);
        return this.getStackFromContents(contents, slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + String.valueOf(stack) + " for slot " + slot + ")");
        }
        ItemContainerContents contents = this.getContents(slot);
        ItemStack existing = this.getStackFromContents(contents, slot);
        if (!ItemStack.matches((ItemStack)stack, (ItemStack)existing)) {
            this.updateContents(contents, stack, slot);
        }
    }

    public ItemStack insertItem(int slot, ItemStack toInsert, boolean simulate) {
        this.validateSlotIndex(slot);
        if (toInsert.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, toInsert)) {
            return toInsert;
        }
        ItemContainerContents contents = this.getContents(slot);
        ItemStack existing = this.getStackFromContents(contents, slot);
        int insertLimit = Math.min(this.getSlotLimit(slot), toInsert.getMaxStackSize());
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)toInsert, (ItemStack)existing)) {
                return toInsert;
            }
            insertLimit -= existing.getCount();
        }
        if (insertLimit <= 0) {
            return toInsert;
        }
        int inserted = Math.min(insertLimit, toInsert.getCount());
        if (!simulate) {
            this.updateContents(contents, toInsert.copyWithCount(existing.getCount() + inserted), slot);
        }
        return toInsert.copyWithCount(toInsert.getCount() - inserted);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemContainerContents contents = this.getContents(slot);
        ItemStack existing = this.getStackFromContents(contents, slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (!simulate) {
            this.updateContents(contents, existing.copyWithCount(existing.getCount() - toExtract), slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public int getSlotLimit(int slot) {
        return 99;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems();
    }

    protected ItemContainerContents getContents(int slot) {
        int index = slot / 256;
        List contentsList = (List)this.parent.getOrDefault(this.component, new ArrayList());
        if (contentsList.size() <= index) {
            return ItemContainerContents.EMPTY;
        }
        return (ItemContainerContents)contentsList.get(index);
    }

    protected ItemStack getStackFromContents(ItemContainerContents contents, int slot) {
        this.validateSlotIndex(slot);
        int contentsIndex = slot % 256;
        return contents.getSlots() <= contentsIndex ? ItemStack.EMPTY : contents.getStackInSlot(contentsIndex);
    }

    protected void updateContents(ItemContainerContents contents, ItemStack stack, int slot) {
        this.validateSlotIndex(slot);
        int index = slot / 256;
        int thisContentsSlots = Math.clamp((long)(this.size - index * 256), 0, 256);
        NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), thisContentsSlots), (Object)ItemStack.EMPTY);
        contents.copyInto(list);
        list.set(slot % 256, (Object)stack);
        ItemContainerContents newContents = ItemContainerContents.fromItems((List)list);
        List<ItemContainerContents> oldContents = this.deepCopy((List)this.parent.getOrDefault(this.component, new ArrayList()));
        if (oldContents.size() > index) {
            oldContents.set(index, newContents);
        } else {
            oldContents.add(newContents);
        }
        this.parent.set(this.component, oldContents);
    }

    protected final void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    private List<ItemContainerContents> deepCopy(List<ItemContainerContents> containerContents) {
        ArrayList<ItemContainerContents> newContainerContents = new ArrayList<ItemContainerContents>();
        for (ItemContainerContents contents : containerContents) {
            NonNullList newStacks = NonNullList.withSize((int)contents.getSlots(), (Object)ItemStack.EMPTY);
            contents.copyInto(newStacks);
            newContainerContents.add(ItemContainerContents.fromItems((List)newStacks));
        }
        return newContainerContents;
    }
}

