/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.inventory.CompressionItemStackHandler;
import dev.willyelton.crystal_tools.common.inventory.CrystalBackpackInventory;
import dev.willyelton.crystal_tools.common.inventory.container.BaseContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.ScrollableMenu;
import dev.willyelton.crystal_tools.common.inventory.container.slot.CrystalSlotItemHandler;
import dev.willyelton.crystal_tools.common.inventory.container.slot.ReadOnlySlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.ScrollableSlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.backpack.BackpackFilterSlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.backpack.CompressionInputSlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.backpack.CompressionOutputSlot;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterMenuContents;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenType;
import dev.willyelton.crystal_tools.common.levelable.CrystalBackpack;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CrystalBackpackContainerMenu
extends BaseContainerMenu
implements ScrollableMenu,
SubScreenContainerMenu,
FilterContainerMenu {
    public static final int START_Y = 18;
    private static final int START_X = 8;
    private static final int SLOTS_PER_ROW = 9;
    public static final int FILTER_SLOTS_PER_ROW = 9;
    private final CrystalBackpackInventory inventory;
    private CompressionItemStackHandler compressionInventory;
    private final FilterMenuContents<CrystalBackpackContainerMenu> filterMenuContents;
    private final ItemStack stack;
    private final Player player;
    private final int slotIndex;
    private final int rows;
    private final int filterRows;
    private final boolean canSort;
    private final boolean canCompress;
    private int maxRows;
    private SubScreenType openSubScreen = SubScreenType.NONE;
    private final NonNullList<ScrollableSlot> backpackSlots;
    private NonNullList<CompressionInputSlot> compressionInputSlots;
    private NonNullList<CompressionOutputSlot> compressionOutputSlots;

    public CrystalBackpackContainerMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf data) {
        this(containerId, playerInventory, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)data), data.readInt());
    }

    public CrystalBackpackContainerMenu(int containerId, Inventory playerInventory, ItemStack stack, int slotIndex) {
        super((MenuType)Registration.CRYSTAL_BACKPACK_CONTAINER.get(), containerId, playerInventory, null);
        this.inventory = CrystalBackpack.getInventory(stack);
        this.stack = stack;
        this.player = playerInventory.player;
        this.slotIndex = slotIndex;
        this.rows = this.inventory.getSlots() / 9;
        this.filterRows = (Integer)stack.getOrDefault(DataComponents.FILTER_CAPACITY, (Object)0);
        this.filterMenuContents = new FilterMenuContents<CrystalBackpackContainerMenu>(this, this.filterRows * 9, (Boolean)stack.getOrDefault(DataComponents.WHITELIST, (Object)true));
        this.canSort = (Boolean)stack.getOrDefault(DataComponents.SORT_ENABLED, (Object)false);
        this.canCompress = (Boolean)stack.getOrDefault(DataComponents.COMPRESSION_ENABLED, (Object)false);
        this.backpackSlots = NonNullList.createWithCapacity((int)(this.rows * 9));
    }

    private void setUpPlayerSlots() {
        this.layoutPlayerInventorySlots(8, 18 + Math.min(this.maxRows, this.rows) * 18 + 14);
    }

    private void setUpBackpackSlots() {
        int rowsToDraw = this.maxRows == 0 ? this.rows : Math.min(this.rows, this.maxRows);
        this.addSlotBox((IItemHandler)this.inventory, 0, 8, 18, 9, 18, rowsToDraw, 18, this.backpackSlots, ScrollableSlot::new);
    }

    private void setUpFilterSlots() {
        if (Objects.nonNull(this.filterMenuContents.getInventory())) {
            int filterRows = Math.min(this.rows, this.getFilterRows());
            this.addSlotBox((IItemHandler)this.filterMenuContents.getInventory(), 0, 8, 18, 9, 18, filterRows, 18, this.filterMenuContents.getFilterSlots(), BackpackFilterSlot::new);
            this.filterMenuContents.toggleSlots(false);
        }
    }

    private void setUpCompressionSlots() {
        this.compressionInputSlots = NonNullList.createWithCapacity((int)(this.getCompressionSlots() / 2));
        this.compressionOutputSlots = NonNullList.createWithCapacity((int)(this.getCompressionSlots() / 2));
        this.compressionInventory = this.createCompressionInventory(this.stack);
        int compressionRows = this.getCompressionRows();
        for (int i = 0; i < compressionRows; ++i) {
            for (int j = 0; j < 3; ++j) {
                CompressionOutputSlot outputSlot = new CompressionOutputSlot((IItemHandler)this.compressionInventory, i * 6 + j * 2 + 1, 8 + j * 54 + 32, 18 + 18 * i);
                CompressionInputSlot inputSlot = new CompressionInputSlot(this.compressionInventory, i * 6 + j * 2, 8 + j * 54, 18 + 18 * i, outputSlot, this.player.level());
                outputSlot.setInputSlot(inputSlot);
                outputSlot.setActive(false);
                inputSlot.setActive(false);
                this.addSlot((Slot)inputSlot);
                this.addSlot((Slot)outputSlot);
                this.compressionInputSlots.add((Object)inputSlot);
                this.compressionOutputSlots.add((Object)outputSlot);
            }
        }
    }

    @Override
    public void setUpSlots() {
        this.setUpPlayerSlots();
        this.setUpBackpackSlots();
        this.setUpFilterSlots();
        this.setUpCompressionSlots();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem() && !this.isFilterSlot(index)) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 36) {
                switch (this.openSubScreen) {
                    case NONE: {
                        if (this.moveItemStackTo(itemstack1, 36, this.slots.size() - this.filterMenuContents.getSlotCount() - this.getCompressionSlots(), false) || (itemstack1 = this.inventory.insertStack(itemstack)).isEmpty()) break;
                        return ItemStack.EMPTY;
                    }
                    case COMPRESS: {
                        return this.quickMoveToCompression(itemstack);
                    }
                    case FILTER: {
                        return this.filterMenuContents.quickMove(itemstack);
                    }
                }
            } else if (!this.moveItemStackTo(itemstack1, 0, 36, true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    private ItemStack quickMoveToCompression(ItemStack stack) {
        if (!stack.isEmpty()) {
            for (CompressionInputSlot inputSlot : this.compressionInputSlots) {
                if (!inputSlot.getItem().isEmpty()) continue;
                inputSlot.onClicked(stack);
                break;
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.stack != null;
    }

    @Override
    protected void layoutHotbar(int leftCol, int topRow) {
        int index = 0;
        int x = leftCol;
        for (int i = 0; i < 9; ++i) {
            if (this.playerInventory.getInv().getItem(index).is((Item)Registration.CRYSTAL_BACKPACK.get())) {
                this.addSlot((Slot)new ReadOnlySlot((IItemHandler)this.playerInventory, index, x, topRow));
            } else {
                this.addSlot((Slot)new CrystalSlotItemHandler((IItemHandler)this.playerInventory, index, x, topRow));
            }
            x += 18;
            ++index;
        }
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 0) {
            Slot slot;
            Slot slot2 = slot = this.getSlot(slotId);
            Objects.requireNonNull(slot2);
            Slot slot3 = slot2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompressionInputSlot.class, CompressionOutputSlot.class, BackpackFilterSlot.class}, (Object)slot3, n)) {
                case 0: {
                    CompressionInputSlot compressionInputSlot = (CompressionInputSlot)slot3;
                    compressionInputSlot.onClicked(this.getCarried());
                    break;
                }
                case 1: {
                    CompressionOutputSlot compressionOutputSlot = (CompressionOutputSlot)slot3;
                    compressionOutputSlot.onClicked(this.getCarried());
                    break;
                }
                case 2: {
                    BackpackFilterSlot filterSlot = (BackpackFilterSlot)slot3;
                    if (Objects.isNull(this.filterMenuContents.getInventory()) || clickType == ClickType.THROW || clickType == ClickType.CLONE) {
                        return;
                    }
                    filterSlot.onClicked(this.getCarried());
                    break;
                }
                default: {
                    super.clicked(slotId, button, clickType, player);
                    break;
                }
            }
        } else {
            super.clicked(slotId, button, clickType, player);
        }
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getFilterRows() {
        return this.filterRows;
    }

    public boolean canSort() {
        return this.canSort;
    }

    public boolean canCompress() {
        return this.canCompress;
    }

    @Override
    public void setWhitelist(boolean whitelist) {
        FilterContainerMenu.super.setWhitelist(whitelist);
        this.stack.set(DataComponents.WHITELIST, (Object)whitelist);
    }

    public void sort() {
        this.inventory.sort((CrystalBackpackInventory.SortType)((Object)CrystalToolsConfig.BACKPACK_SORT_TYPE.get()));
    }

    public int getCompressionRows() {
        if (this.canScroll()) {
            return Math.min(this.maxRows, (Integer)CrystalToolsConfig.MAX_COMPRESSION_SLOT_ROWS.get());
        }
        return Math.min(this.rows, (Integer)CrystalToolsConfig.MAX_COMPRESSION_SLOT_ROWS.get());
    }

    private int getCompressionSlots() {
        return this.getCompressionRows() * 6;
    }

    @Override
    public IItemHandlerModifiable getFilterInventory() {
        if (this.filterRows == 0) {
            return null;
        }
        return new ComponentItemHandler((MutableDataComponentHolder)this.stack, (DataComponentType)DataComponents.FILTER_INVENTORY.get(), this.filterRows * 9);
    }

    private CompressionItemStackHandler createCompressionInventory(ItemStack stack) {
        return new CompressionItemStackHandler(stack, (DataComponentType<ItemContainerContents>)((DataComponentType)DataComponents.COMPRESSION_INVENTORY.get()), this.getCompressionSlots());
    }

    private boolean isFilterSlot(int index) {
        return index >= this.getNonFilterSlots();
    }

    private int getNonFilterSlots() {
        int displayedRows = this.maxRows == 0 ? this.rows : Math.min(this.rows, this.maxRows);
        return 36 + displayedRows * 9;
    }

    @Override
    public int getRowIndexForScroll(float scrollOffset) {
        return Math.max((int)((double)(scrollOffset * (float)(this.rows - this.maxRows)) + 0.5), 0);
    }

    @Override
    public float getScrollForRowIndex(int row) {
        return Mth.clamp((float)((float)row / (float)(this.rows - this.maxRows)), (float)0.0f, (float)1.0f);
    }

    @Override
    public void scrollTo(int row) {
        if (row > this.rows - this.maxRows || row < 0) {
            return;
        }
        for (int i = 0; i < this.backpackSlots.size(); ++i) {
            ((ScrollableSlot)((Object)this.backpackSlots.get(i))).setSlotIndex(i + row * 9);
        }
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        if (this.slots.isEmpty()) {
            this.setUpSlots();
        }
    }

    @Override
    public boolean canScroll() {
        return this.rows > this.maxRows;
    }

    public Inventory getPlayerInventory() {
        return (Inventory)this.playerInventory.getInv();
    }

    @Override
    public void openSubScreen(SubScreenType subScreenType) {
        this.openSubScreen = subScreenType;
        this.backpackSlots.forEach(scrollableSlot -> scrollableSlot.setActive(false));
        if (subScreenType == SubScreenType.FILTER) {
            this.filterMenuContents.toggleSlots(true);
        } else if (subScreenType == SubScreenType.COMPRESS) {
            this.compressionInputSlots.forEach(compressionInputSlot -> compressionInputSlot.setActive(true));
            this.compressionOutputSlots.forEach(compressionOutputSlot -> compressionOutputSlot.setActive(true));
        }
    }

    @Override
    public void closeSubScreen() {
        this.openSubScreen = SubScreenType.NONE;
        this.backpackSlots.forEach(scrollableSlot -> scrollableSlot.setActive(true));
        this.compressionInputSlots.forEach(compressionInputSlot -> compressionInputSlot.setActive(false));
        this.compressionOutputSlots.forEach(compressionOutputSlot -> compressionOutputSlot.setActive(false));
        this.filterMenuContents.toggleSlots(false);
    }

    public void reopenBackpack() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.player.closeContainer();
            CrystalBackpack backpack = (CrystalBackpack)this.stack.getItem();
            backpack.openBackpack(serverPlayer, this.stack, this.slotIndex);
        }
    }

    public void compress() {
        int compressionSlots = this.getCompressionSlots();
        for (int i = 0; i < compressionSlots; i += 2) {
            ItemStack inputItem = this.compressionInventory.getStackInSlot(i);
            ItemStack outputItem = this.compressionInventory.getStackInSlot(i + 1);
            if (inputItem.isEmpty() || outputItem.isEmpty()) continue;
            int count = 0;
            for (int j = 0; j < this.inventory.getSlots(); ++j) {
                ItemStack stack = this.inventory.getStackInSlot(j);
                if (!stack.is(inputItem.getItem())) continue;
                count += stack.getCount();
                this.inventory.setStackInSlot(j, ItemStack.EMPTY);
            }
            int requiredCount = this.compressionInventory.getMode(i).getCount();
            if (requiredCount == 0) continue;
            int outputCount = count / requiredCount;
            int inputCount = count % requiredCount;
            ItemStack inputStack = new ItemStack((ItemLike)inputItem.getItem(), inputCount);
            this.inventory.insertStack(inputStack);
            int outputStackCount = outputCount / outputItem.getMaxStackSize();
            int outputRemainder = outputCount % outputItem.getMaxStackSize();
            for (int j = 0; j < outputStackCount; ++j) {
                this.inventory.insertStack(new ItemStack((ItemLike)outputItem.getItem(), outputItem.getMaxStackSize()));
            }
            this.inventory.insertStack(new ItemStack((ItemLike)outputItem.getItem(), outputRemainder));
        }
    }

    @Override
    public void matchContentsFilter(boolean isShiftDown) {
        this.filterMenuContents.matchContents((IItemHandler)this.inventory, isShiftDown);
    }

    @Override
    public FilterMenuContents<?> getFilterMenuContents() {
        return this.filterMenuContents;
    }

    public ItemStack getBackpackStack() {
        return this.stack;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }
}

