/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.inventory.container.BaseContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalPedestalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CrystalPedestalContainerMenu
extends BaseContainerMenu {
    public static final int CONTAINER_ROWS = 3;
    private final CrystalPedestalBlockEntity blockEntity;

    public CrystalPedestalContainerMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf data) {
        this(containerId, playerInventory, data.readBlockPos());
    }

    public CrystalPedestalContainerMenu(int containerId, Inventory playerInventory, BlockPos pos) {
        super((MenuType)Registration.CRYSTAL_PEDESTAL_CONTAINER.get(), containerId, playerInventory, null);
        Level level = playerInventory.player.level();
        this.blockEntity = (CrystalPedestalBlockEntity)level.getBlockEntity(pos);
        if (this.blockEntity == null) {
            return;
        }
        this.addSlotBox(this.blockEntity.getContentsHandler(), 0, 8, 18, 9, 18, 3, 18);
        this.layoutPlayerInventorySlots(8, 85);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 27 ? !this.moveItemStackTo(itemstack1, 27, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        if (this.level != null && this.level.getBlockEntity(this.blockEntity.getBlockPos()) != this.blockEntity) {
            return false;
        }
        return player.distanceToSqr((double)this.blockEntity.getBlockPos().getX() + 0.5, (double)this.blockEntity.getBlockPos().getY() + 0.5, (double)this.blockEntity.getBlockPos().getZ() + 0.5) <= 64.0;
    }
}

