/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container.slot;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerCopySlot;
import org.jetbrains.annotations.NotNull;

public class ScrollableSlot
extends ItemHandlerCopySlot {
    private int actualSlotIndex;
    private boolean active = true;

    public ScrollableSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.actualSlotIndex = index;
    }

    public void setSlotIndex(int slot) {
        this.actualSlotIndex = slot;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.getItemHandler().isItemValid(this.actualSlotIndex, stack);
    }

    public ItemStack getStackCopy() {
        return this.getItemHandler().getStackInSlot(this.actualSlotIndex);
    }

    public void setStackCopy(@NotNull ItemStack stack) {
        ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.actualSlotIndex, stack);
    }

    public int getMaxStackSize() {
        return this.getItemHandler().getSlotLimit(this.actualSlotIndex);
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        ItemStack maxAdd = stack.copy();
        int maxInput = stack.getMaxStackSize();
        maxAdd.setCount(maxInput);
        IItemHandler handler = this.getItemHandler();
        ItemStack currentStack = handler.getStackInSlot(this.actualSlotIndex);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            handlerModifiable.setStackInSlot(this.actualSlotIndex, ItemStack.EMPTY);
            ItemStack remainder = handlerModifiable.insertItem(this.actualSlotIndex, maxAdd, true);
            handlerModifiable.setStackInSlot(this.actualSlotIndex, currentStack);
            return maxInput - remainder.getCount();
        }
        ItemStack remainder = handler.insertItem(this.actualSlotIndex, maxAdd, true);
        int current = currentStack.getCount();
        int added = maxInput - remainder.getCount();
        return current + added;
    }

    public boolean mayPickup(Player playerIn) {
        return !this.getItemHandler().extractItem(this.actualSlotIndex, 1, true).isEmpty();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isSameInventory(Slot other) {
        ItemHandlerCopySlot itemHandlerCopySlot;
        return other instanceof ItemHandlerCopySlot && (itemHandlerCopySlot = (ItemHandlerCopySlot)other).getItemHandler() == this.getItemHandler();
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

