/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container.subscreen;

import dev.willyelton.crystal_tools.common.inventory.container.BaseContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.slot.backpack.BackpackFilterSlot;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterContainerMenu;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class FilterMenuContents<T extends BaseContainerMenu> {
    private final T menu;
    @Nullable
    private final IItemHandlerModifiable filterInventory;
    private final NonNullList<BackpackFilterSlot> filterSlots;
    private boolean whitelist;

    public FilterMenuContents(T menu, int filterSlots, boolean whiteList) {
        this.menu = menu;
        this.filterInventory = filterSlots > 0 ? ((FilterContainerMenu)menu).getFilterInventory() : null;
        this.filterSlots = NonNullList.createWithCapacity((int)(filterSlots * 9));
        this.whitelist = whiteList;
    }

    public boolean getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
    }

    public int getSlotCount() {
        if (this.filterInventory != null) {
            return this.filterInventory.getSlots();
        }
        return 0;
    }

    public NonNullList<BackpackFilterSlot> getFilterSlots() {
        return this.filterSlots;
    }

    public IItemHandlerModifiable getInventory() {
        return this.filterInventory;
    }

    public void addSlot(BackpackFilterSlot slot) {
        this.filterSlots.add((Object)slot);
    }

    public ItemStack quickMove(ItemStack stack) {
        if (!stack.isEmpty()) {
            for (BackpackFilterSlot filterSlot : this.filterSlots) {
                if (!filterSlot.getItem().isEmpty()) continue;
                filterSlot.onClicked(stack);
                break;
            }
        }
        return ItemStack.EMPTY;
    }

    public void toggleSlots(boolean enabled) {
        this.filterSlots.forEach(filterSlot -> filterSlot.setActive(enabled));
    }

    public void clear() {
        if (this.filterInventory != null) {
            InventoryUtils.clear(this.filterInventory);
        }
    }

    public void matchContents(IItemHandler inventory, boolean shiftDown) {
        if (this.filterInventory == null) {
            return;
        }
        if (shiftDown) {
            InventoryUtils.clear(this.filterInventory);
        }
        int filterIndex = 0;
        for (int i = 0; i < inventory.getSlots() && filterIndex < this.getSlotCount(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i).copy();
            stack.setCount(1);
            if (InventoryUtils.contains(this.filterInventory, stack)) continue;
            while (!this.filterInventory.getStackInSlot(filterIndex).isEmpty()) {
                if (++filterIndex < this.getSlotCount()) continue;
                return;
            }
            this.filterInventory.setStackInSlot(filterIndex++, stack);
        }
    }
}

