/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable;

import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.compat.curios.CuriosCompatibility;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.inventory.CrystalBackpackInventory;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalBackpackContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class CrystalBackpack
extends Item
implements LevelableItem {
    public CrystalBackpack() {
        super(new Item.Properties().stacksTo(1).fireResistant());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openBackpack(serverPlayer, stack, serverPlayer.getInventory().findSlotMatchingItem(stack));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void openBackpack(ServerPlayer serverPlayer, ItemStack backpackStack, int slotIndex) {
        serverPlayer.openMenu((MenuProvider)new CrystalBackpackMenuSupplier(this, backpackStack, slotIndex), friendlyByteBuf -> {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(friendlyByteBuf, (Object)backpackStack);
            friendlyByteBuf.writeInt(slotIndex);
        });
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
        ItemStack backpackStack = context.getItemInHand();
        if (((Boolean)backpackStack.getOrDefault(DataComponents.INVENTORY_STORE, (Object)false)).booleanValue()) {
            CrystalBackpackInventory backpackInventory = CrystalBackpack.getInventory(backpackStack);
            if (blockEntity != null && backpackInventory != null) {
                IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, context.getClickedPos(), (Object)context.getClickedFace());
                if (itemHandler != null) {
                    for (int i = 0; i < backpackInventory.getSlots(); ++i) {
                        backpackInventory.setStackInSlot(i, ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)backpackInventory.getStackInSlot(i), (boolean)false));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public boolean mineBlock(ItemStack tool, Level level, BlockState blockState, BlockPos blockPos, LivingEntity entity) {
        if (this.isDisabled()) {
            tool.shrink(1);
            return false;
        }
        return true;
    }

    @Override
    public String getItemType() {
        return "backpack";
    }

    @Override
    public int getMaxDamage(ItemStack itemStack) {
        return 1;
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)CrystalToolsConfig.DISABLE_BACKPACK.get();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (((Boolean)itemStack.getOrDefault(DataComponents.BACKPACK_AUTO_PICKUP, (Object)false)).booleanValue()) {
            String toolTip = "\u00a79Auto Pickup " + ((Boolean)itemStack.getOrDefault(DataComponents.PICKUP_DISABLED, (Object)false) != false ? "Disabled" : "Enabled");
            components.add((Component)Component.literal((String)toolTip));
        }
        this.appendLevelableHoverText(itemStack, components, this, flag);
    }

    public boolean overrideStackedOnOther(ItemStack backpackStack, Slot slot, ClickAction action, Player player) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        CrystalBackpackInventory inventory = CrystalBackpack.getInventory(backpackStack);
        ItemStack toInsert = slot.getItem();
        if (toInsert.isEmpty()) {
            int lastSlotIndex = inventory.getLastStack();
            if (lastSlotIndex != -1) {
                ItemStack toGiveToPlayer = inventory.getStackInSlot(lastSlotIndex);
                ItemStack result = slot.safeInsert(toGiveToPlayer);
                inventory.setStackInSlot(lastSlotIndex, result);
                this.playRemoveOneSound((Entity)player);
                return true;
            }
        } else if (toInsert.getItem().canFitInsideContainerItems()) {
            ItemStack result = inventory.insertStack(toInsert);
            slot.set(result);
            this.playInsertSound((Entity)player);
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack backpackStack, ItemStack toInsert, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        CrystalBackpackInventory inventory = CrystalBackpack.getInventory(backpackStack);
        if (toInsert.isEmpty()) {
            int lastSlotIndex = inventory.getLastStack();
            if (lastSlotIndex != -1) {
                ItemStack toGiveToPlayer = inventory.getStackInSlot(lastSlotIndex);
                access.set(toGiveToPlayer);
                this.playRemoveOneSound((Entity)player);
                return true;
            }
        } else {
            ItemStack result = inventory.insertStack(toInsert.copy());
            toInsert.setCount(result.getCount());
            this.playInsertSound((Entity)player);
            return true;
        }
        return false;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public int getExperienceCap(ItemStack tool) {
        return (Integer)tool.getOrDefault(DataComponents.EXPERIENCE_CAP, (Object)((Integer)CrystalToolsConfig.BACKPACK_BASE_EXPERIENCE_CAP.get()));
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public static List<ItemStack> findBackpackStacks(Player player) {
        return InventoryUtils.findAll(player, stack -> stack.is((Item)Registration.CRYSTAL_BACKPACK.get()));
    }

    public static int findNextBackpackSlot(Player player) {
        List<ItemStack> curiosStacks = CuriosCompatibility.getCrystalBackpacksInCurios(player);
        if (!curiosStacks.isEmpty()) {
            return -2;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!player.getInventory().getItem(i).is((Item)Registration.CRYSTAL_BACKPACK.get())) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getBackpackFromSlotIndex(Player player, int slotIndex) {
        if (slotIndex == -1) {
            return ItemStack.EMPTY;
        }
        if (slotIndex == -2) {
            List<ItemStack> curiosStacks = CuriosCompatibility.getCrystalBackpacksInCurios(player);
            if (curiosStacks.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return curiosStacks.get(0);
        }
        return player.getInventory().getItem(slotIndex);
    }

    public static CrystalBackpackInventory getInventory(ItemStack stack) {
        IItemHandler inventory = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (inventory == null) {
            CrystalTools.LOGGER.error("Crystal Backpack cannot find capability");
            return new CrystalBackpackInventory(0);
        }
        if (inventory instanceof CrystalBackpackInventory) {
            CrystalBackpackInventory crystalBackpackInventory = (CrystalBackpackInventory)inventory;
            return crystalBackpackInventory;
        }
        CrystalTools.LOGGER.error("Different inventory capability found on crystal backpack");
        return new CrystalBackpackInventory(0);
    }

    public static void addXpToBackpacks(Player player, int exp) {
        CrystalBackpack.findBackpackStacks(player).forEach(stack -> {
            LevelableItem item = (LevelableItem)stack.getItem();
            item.addExp((ItemStack)stack, player.level(), player.blockPosition(), (LivingEntity)player, exp);
        });
    }

    private record CrystalBackpackMenuSupplier(CrystalBackpack backpackItem, ItemStack stack, int slotIndex) implements MenuProvider
    {
        public Component getDisplayName() {
            return this.stack.getHoverName();
        }

        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            return new CrystalBackpackContainerMenu(containerId, playerInventory, this.stack, this.slotIndex);
        }
    }
}

