/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillDataNode;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import dev.willyelton.crystal_tools.utils.StringUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public interface LevelableItem {
    public static final Tier INITIAL_TIER = Tiers.NETHERITE;

    default public void addExp(ItemStack tool, Level level, BlockPos blockPos, LivingEntity player) {
        this.addExp(tool, level, blockPos, player, 1);
    }

    default public void addExp(ItemStack tool, Level level, BlockPos blockPos, LivingEntity livingEntity, int amount) {
        int experienceCap;
        int newExperience = DataComponents.addToComponent(tool, DataComponents.SKILL_EXPERIENCE, amount);
        if (newExperience >= (experienceCap = this.getExperienceCap(tool))) {
            DataComponents.addToComponent(tool, DataComponents.SKILL_POINTS, 1);
            level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 0.8f, 1.0f);
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                Item item = tool.getItem();
                if (item instanceof LevelableItem) {
                    LevelableItem item2 = (LevelableItem)item;
                    player.displayClientMessage((Component)Component.literal((String)("\u00a7b" + tool.getItem().getName(tool).getString() + " Leveled Up (" + item2.getSkillPoints(tool) + " Unspent Points)")), true);
                }
            }
            tool.set(DataComponents.SKILL_EXPERIENCE, (Object)Math.max(0, newExperience - experienceCap));
            ToolUtils.increaseExpCap(tool);
        }
    }

    default public int getSkillPoints(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
    }

    default public int getExperienceCap(ItemStack tool) {
        return (Integer)tool.getOrDefault(DataComponents.EXPERIENCE_CAP, (Object)((Integer)CrystalToolsConfig.BASE_EXPERIENCE_CAP.get()));
    }

    public String getItemType();

    public int getMaxDamage(ItemStack var1);

    public boolean isDisabled();

    default public ItemAttributeModifiers getLevelableAttributeModifiers(ItemStack stack) {
        return ItemAttributeModifiers.EMPTY;
    }

    default public void appendLevelableHoverText(ItemStack stack, List<Component> components, LevelableItem item, TooltipFlag tooltipFlag) {
        String changeKey;
        String mode;
        if (item.isDisabled()) {
            components.add((Component)Component.literal((String)"\u00a7c\u00a7lDisabled"));
            return;
        }
        int newExperience = (Integer)stack.getOrDefault(DataComponents.SKILL_EXPERIENCE, (Object)0);
        int experienceCap = item.getExperienceCap(stack);
        int durability = item.getMaxDamage(stack) - stack.getDamageValue();
        if (durability <= 1 && item.getMaxDamage(stack) != 1) {
            components.add((Component)Component.literal((String)"\u00a7c\u00a7lBroken"));
        }
        components.add((Component)Component.literal((String)String.format("%d/%d XP To Next Level", newExperience, experienceCap)));
        int skillPoints = (Integer)stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
        if (skillPoints > 0) {
            components.add((Component)Component.literal((String)String.format("%d Unspent Skill Points", skillPoints)));
        }
        if (((Boolean)stack.getOrDefault(DataComponents.MINE_MODE, (Object)false)).booleanValue() && ((Boolean)stack.getOrDefault(DataComponents.SILK_TOUCH_BONUS, (Object)false)).booleanValue() && (Integer)stack.getOrDefault(DataComponents.FORTUNE_BONUS, (Object)0) > 0) {
            mode = EnchantmentUtils.hasEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH) ? "Silk Touch" : "Fortune";
            changeKey = RegisterKeyBindingsEvent.MODE_SWITCH == null ? "" : " (" + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to change)";
            components.add((Component)Component.literal((String)("\u00a79Mine Mode: " + mode + changeKey)));
        }
        if (((Boolean)stack.getOrDefault(DataComponents.MINE_MODE, (Object)false)).booleanValue() && ((Boolean)stack.getOrDefault(DataComponents.HAS_3x3, (Object)false)).booleanValue()) {
            mode = (Boolean)stack.getOrDefault(DataComponents.DISABLE_3x3, (Object)false) != false ? "1x1" : "3x3";
            changeKey = RegisterKeyBindingsEvent.MODE_SWITCH == null ? "" : " (Shift + " + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to change)";
            components.add((Component)Component.literal((String)("\u00a79Break Mode: " + mode + changeKey)));
        }
        if (((Boolean)stack.getOrDefault(DataComponents.MINE_MODE, (Object)false)).booleanValue() && ((Boolean)stack.getOrDefault(DataComponents.AUTO_SMELT, (Object)false)).booleanValue()) {
            boolean enabled = (Boolean)stack.getOrDefault(DataComponents.DISABLE_AUTO_SMELT, (Object)false) == false;
            changeKey = RegisterKeyBindingsEvent.MODE_SWITCH == null ? "" : " (Ctrl + " + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to toggle)";
            components.add((Component)Component.literal((String)("\u00a79Auto Smelt " + (enabled ? "Enabled" : "Disabled") + changeKey)));
        }
        if (((Boolean)stack.getOrDefault(DataComponents.AUTO_TARGET, (Object)false)).booleanValue()) {
            boolean enabled = (Boolean)stack.getOrDefault(DataComponents.DISABLE_AUTO_TARGET, (Object)false) == false;
            changeKey = RegisterKeyBindingsEvent.MODE_SWITCH == null ? "" : " (Shift + " + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to toggle)";
            components.add((Component)Component.literal((String)("\u00a79Auto Target " + (enabled ? "Enabled" : "Disabled") + changeKey)));
        }
        this.addAdditionalTooltips(stack, components, item);
        if (!tooltipFlag.hasShiftDown()) {
            components.add((Component)Component.literal((String)"<Hold Shift For Skills>"));
        } else {
            HashMap<String, Float> skills = new HashMap<String, Float>();
            components.add((Component)Component.literal((String)"\u00a76Skills:"));
            SkillData toolData = ToolUtils.getSkillData(stack);
            if (toolData != null) {
                for (SkillDataNode dataNode : toolData.getAllNodes()) {
                    if (dataNode.getPoints() <= 0) continue;
                    skills.compute(dataNode.getKey(), (key, value) -> Float.valueOf(value != null ? value.floatValue() + dataNode.getValue() * (float)dataNode.getPoints() : dataNode.getValue() * (float)dataNode.getPoints()));
                }
                skills.forEach((s, aFloat) -> components.add((Component)Component.literal((String)String.format("\u00a76     %s: %s", StringUtils.formatKey(s), StringUtils.formatFloat(aFloat.floatValue())))));
            }
        }
    }

    default public void addAdditionalTooltips(ItemStack stack, List<Component> components, LevelableItem item) {
    }

    default public void levelableInventoryTick(ItemStack stack, Level level, Entity entity, int inventorySlot, boolean inHand, double repairModifier) {
        if ((!inHand || ((Boolean)CrystalToolsConfig.REPAIR_IN_HAND.get()).booleanValue()) && (Integer)stack.getOrDefault(DataComponents.AUTO_REPAIR, (Object)0) > 0) {
            long gameTimeToRepair = (Long)stack.getOrDefault(DataComponents.AUTO_REPAIR_GAME_TIME, (Object)-1L);
            if (gameTimeToRepair == -1L) {
                stack.set(DataComponents.AUTO_REPAIR_GAME_TIME, (Object)(level.getGameTime() + (long)((double)((Integer)CrystalToolsConfig.TOOL_REPAIR_COOLDOWN.get()).intValue() * repairModifier)));
            } else if (gameTimeToRepair <= level.getGameTime()) {
                stack.set(DataComponents.AUTO_REPAIR_GAME_TIME, (Object)(level.getGameTime() + (long)((double)((Integer)CrystalToolsConfig.TOOL_REPAIR_COOLDOWN.get()).intValue() * repairModifier)));
                int repairAmount = Math.min((Integer)stack.getOrDefault(DataComponents.AUTO_REPAIR, (Object)0), stack.getDamageValue());
                stack.setDamageValue(stack.getDamageValue() - repairAmount);
            }
        }
    }
}

