/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.armor;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.config.CrystalToolsServerConfig;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.levelable.armor.LevelableArmor;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.NeoForgeMod;

public class CrystalElytra
extends ElytraItem
implements LevelableItem {
    private static final ResourceLocation CREATIVE_FLIGHT_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"creative_flight");

    public CrystalElytra(Item.Properties pProperties) {
        super(pProperties.fireResistant());
    }

    @Override
    public String getItemType() {
        return "crystal_elytra";
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        int bonusDurability = (Integer)stack.getOrDefault(DataComponents.DURABILITY_BONUS, (Object)0);
        return INITIAL_TIER.getUses() + bonusDurability;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        String modeSwitchKey = RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString();
        if ((Integer)stack.getOrDefault(DataComponents.CREATIVE_FLIGHT, (Object)0) >= (Integer)CrystalToolsServerConfig.CREATIVE_FLIGHT_POINTS.get()) {
            if (((Boolean)stack.getOrDefault(DataComponents.DISABLE_CREATIVE_FLIGHT, (Object)false)).booleanValue()) {
                components.add((Component)Component.literal((String)("\u00a7c\u00a7lCreative Flight Disabled (Ctrl + " + modeSwitchKey + ") To Enable")));
            } else {
                components.add((Component)Component.literal((String)("\u00a79Ctrl + " + modeSwitchKey + " To Disable Creative Flight")));
            }
        }
        this.appendLevelableHoverText(stack, components, this, flag);
    }

    public boolean isValidRepairItem(ItemStack tool, ItemStack repairItem) {
        return repairItem.is((Item)Registration.CRYSTAL.get());
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return !CrystalElytra.canUseCreativeFlight(stack) && ElytraItem.isFlyEnabled((ItemStack)stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTick;
        if (!entity.level().isClientSide && (nextFlightTick = flightTicks + 1) % 10 == 0) {
            if (nextFlightTick % 20 == 0) {
                float unbreakingLevel = (float)((Integer)stack.getOrDefault(DataComponents.DURABILITY_BONUS, (Object)0)).intValue() / 200.0f + 1.0f;
                if ((double)(1.0f / unbreakingLevel) > Math.random()) {
                    stack.hurtAndBreak(1, entity, EquipmentSlot.CHEST);
                }
                this.addExp(stack, entity.level(), entity.getOnPos(), entity);
            }
            entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
        }
        return true;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durability = this.getMaxDamage(stack) - stack.getDamageValue();
        if (durability - amount <= 0) {
            return 0;
        }
        return amount;
    }

    @Override
    public ItemAttributeModifiers getLevelableAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        if (!ToolUtils.isBroken(stack)) {
            float speedBonus;
            builder.add(Attributes.ARMOR, new AttributeModifier(LevelableArmor.ARMOR_ID, (double)this.getDefense(stack), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(LevelableArmor.ARMOR_TOUGHNESS_ID, (double)this.getToughness(stack), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
            int health = (Integer)stack.getOrDefault(DataComponents.HEALTH_BONUS, (Object)0);
            if (health > 0) {
                builder.add(Attributes.MAX_HEALTH, new AttributeModifier(LevelableArmor.MAX_HEALTH_ID, (double)health, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
            }
            if ((speedBonus = ((Float)stack.getOrDefault(DataComponents.SPEED_BONUS, (Object)Float.valueOf(0.0f))).floatValue() / 5.0f) > 0.0f) {
                builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(LevelableArmor.MOVEMENT_SPEED_ID, (double)speedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.CHEST);
            }
            if (CrystalElytra.canUseCreativeFlight(stack)) {
                builder.add(NeoForgeMod.CREATIVE_FLIGHT, new AttributeModifier(CREATIVE_FLIGHT_ID, 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
            }
            return builder.build();
        }
        return ItemAttributeModifiers.builder().build();
    }

    public static boolean canUseCreativeFlight(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponents.DISABLE_CREATIVE_FLIGHT, (Object)false) == false && (Integer)stack.getOrDefault(DataComponents.CREATIVE_FLIGHT, (Object)0) >= (Integer)CrystalToolsServerConfig.CREATIVE_FLIGHT_POINTS.get();
    }

    public int getDefense(ItemStack stack) {
        return ((ArmorMaterial)ArmorMaterials.NETHERITE.value()).getDefense(ArmorItem.Type.CHESTPLATE) + (Integer)stack.getOrDefault(DataComponents.ARMOR_BONUS, (Object)0);
    }

    public float getToughness(ItemStack stack) {
        return ((ArmorMaterial)ArmorMaterials.NETHERITE.value()).toughness() + ((Float)stack.getOrDefault(DataComponents.TOUGHNESS_BONUS, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.getDamageValue() * 13.0f / (float)itemStack.getMaxDamage());
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.getMaxDamage() - (float)itemStack.getDamageValue()) / (float)itemStack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int inventorySlot, boolean inHand) {
        if (this.isDisabled()) {
            stack.shrink(1);
        }
        this.levelableInventoryTick(stack, level, entity, inventorySlot, inHand, 1.0);
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)CrystalToolsConfig.DISABLE_ELYTRA.get();
    }

    public boolean isEnchantable(ItemStack stack) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is(oldStack.getItem());
    }
}

