/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.armor;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LevelableArmor
extends ArmorItem
implements LevelableItem,
Equipable {
    public static final ResourceLocation ARMOR_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"armor");
    public static final ResourceLocation ARMOR_TOUGHNESS_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"armor_toughness");
    public static final ResourceLocation MAX_HEALTH_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"max_health");
    public static final ResourceLocation MOVEMENT_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"movement_speed");
    protected final String itemType;

    public LevelableArmor(String itemType, ArmorItem.Type type) {
        super(ArmorMaterials.NETHERITE, type, new Item.Properties().fireResistant().durability(INITIAL_TIER.getUses()));
        this.itemType = itemType;
    }

    @Override
    public ItemAttributeModifiers getLevelableAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        if (!ToolUtils.isBroken(stack)) {
            float speedBonus;
            builder.add(Attributes.ARMOR, new AttributeModifier(ARMOR_ID, (double)this.getDefense(stack), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(ARMOR_TOUGHNESS_ID, (double)this.getToughness(stack), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
            int health = (Integer)stack.getOrDefault(DataComponents.HEALTH_BONUS, (Object)0);
            if (health > 0) {
                builder.add(Attributes.MAX_HEALTH, new AttributeModifier(MAX_HEALTH_ID, (double)health, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
            }
            if ((speedBonus = ((Float)stack.getOrDefault(DataComponents.SPEED_BONUS, (Object)Float.valueOf(0.0f))).floatValue() / 5.0f) > 0.0f) {
                builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(MOVEMENT_SPEED_ID, (double)speedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
            }
            return builder.build();
        }
        return ItemAttributeModifiers.builder().build();
    }

    public int getDefense(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.ARMOR_BONUS, (Object)0);
    }

    public float getToughness(ItemStack stack) {
        return ((Float)stack.getOrDefault(DataComponents.TOUGHNESS_BONUS, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)String.format("textures/models/armor/crystal_layer_%d.png", slot == EquipmentSlot.LEGS ? 2 : 1));
    }

    @Override
    public String getItemType() {
        return this.itemType;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        String modeSwitchKey = RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString();
        if (((Boolean)stack.getOrDefault(DataComponents.NIGHT_VISION, (Object)false)).booleanValue()) {
            if (((Boolean)stack.getOrDefault(DataComponents.DISABLE_NIGHT_VISION, (Object)false)).booleanValue()) {
                components.add((Component)Component.literal((String)("\u00a7c\u00a7lNight Vision Disabled (" + modeSwitchKey + ") To Enable")));
            } else {
                components.add((Component)Component.literal((String)("\u00a79" + modeSwitchKey + " To Disable Night Vision")));
            }
        }
        if (((Boolean)stack.getOrDefault(DataComponents.FROST_WALKER, (Object)false)).booleanValue()) {
            if (EnchantmentUtils.hasEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.FROST_WALKER)) {
                components.add((Component)Component.literal((String)("\u00a79Shift + " + modeSwitchKey + " To Disable Frost Walker")));
            } else {
                components.add((Component)Component.literal((String)("\u00a7c\u00a7lFrost Walker Disabled (Shift + " + modeSwitchKey + ") To Enable")));
            }
        }
        this.appendLevelableHoverText(stack, components, this, flag);
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        int bonusDurability = (Integer)stack.getOrDefault(DataComponents.DURABILITY_BONUS, (Object)0);
        return INITIAL_TIER.getUses() + bonusDurability;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durability = this.getMaxDamage(stack) - stack.getDamageValue();
        if (durability - amount <= 0) {
            return 0;
        }
        return amount;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.getDamageValue() * 13.0f / (float)itemStack.getMaxDamage());
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.getMaxDamage() - (float)itemStack.getDamageValue()) / (float)itemStack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int inventorySlot, boolean inHand) {
        if (this.isDisabled()) {
            stack.shrink(1);
            return;
        }
        if (!ToolUtils.isBroken(stack) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((Boolean)stack.getOrDefault(DataComponents.NIGHT_VISION, (Object)false)).booleanValue() && livingEntity.getItemBySlot(EquipmentSlot.HEAD).equals(stack) && !((Boolean)stack.getOrDefault(DataComponents.DISABLE_NIGHT_VISION, (Object)false)).booleanValue()) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
            }
        }
        this.levelableInventoryTick(stack, level, entity, inventorySlot, inHand, 1.0);
    }

    public boolean isValidRepairItem(ItemStack tool, ItemStack repairItem) {
        return repairItem.is((Item)Registration.CRYSTAL.get());
    }

    public int getEnchantmentValue() {
        return INITIAL_TIER.getEnchantmentValue();
    }

    @Override
    public boolean isDisabled() {
        switch (this.itemType) {
            case "helmet": {
                return (Boolean)CrystalToolsConfig.DISABLE_HELMET.get();
            }
            case "chestplate": {
                return (Boolean)CrystalToolsConfig.DISABLE_CHESTPLATE.get();
            }
            case "leggings": {
                return (Boolean)CrystalToolsConfig.DISABLE_LEGGINGS.get();
            }
            case "boots": {
                return (Boolean)CrystalToolsConfig.DISABLE_BOOTS.get();
            }
        }
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is(oldStack.getItem());
    }
}

