/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.QuarryData;
import dev.willyelton.crystal_tools.common.components.QuarryUpgrades;
import dev.willyelton.crystal_tools.common.levelable.block.LevelableBlockItem;
import dev.willyelton.crystal_tools.utils.StringUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CrystalQuarryBlockItem
extends LevelableBlockItem {
    public CrystalQuarryBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        ItemStack stack = context.getItemInHand();
        List bounds = (List)stack.get(DataComponents.QUARRY_BOUNDS);
        if (bounds != null && bounds.size() == 4) {
            if (this.isOutside(bounds, context.getClickedPos()) && this.isOneAway(bounds, context.getClickedPos())) {
                return true;
            }
            Player player = context.getPlayer();
            if (player != null && !player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7c\u00a7lQuarry must be placed next to the stabilizer boundary"), true);
            }
            return false;
        }
        Player player = context.getPlayer();
        if (player != null && !player.level().isClientSide()) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a7c\u00a7lQuarry must be linked to stabilizers to place"), true);
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        List stabilizers;
        QuarryUpgrades quarryUpgrades;
        components.add((Component)Component.literal((String)"Quarry is currently still a WIP. Please report any issues or comment suggestions!").withStyle(ChatFormatting.RED));
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (tooltipFlag.hasShiftDown() && (quarryUpgrades = (QuarryUpgrades)stack.get(DataComponents.QUARRY_UPGRADES)) != null) {
            if (quarryUpgrades.speedUpgrade() > 0.0f) {
                components.add((Component)Component.literal((String)String.format("\u00a76     %s: %s", "Speed", StringUtils.formatFloat(quarryUpgrades.speedUpgrade()))));
            }
            if (quarryUpgrades.redstoneControl()) {
                components.add((Component)Component.literal((String)"\u00a76     Redstone Control"));
            }
            if (quarryUpgrades.fortuneLevel() > 0) {
                components.add((Component)Component.literal((String)String.format("\u00a76     %s %s", "Fortune", StringUtils.formatFloat(quarryUpgrades.fortuneLevel()))));
            }
            if (quarryUpgrades.silkTouch()) {
                components.add((Component)Component.literal((String)"\u00a76     Silk Touch"));
            }
            if (quarryUpgrades.extraEnergyCost() > 0) {
                components.add((Component)Component.literal((String)String.format("\u00a7c     +%s Extra Energy", StringUtils.formatFloat(quarryUpgrades.extraEnergyCost()))));
            }
        }
        if ((stabilizers = (List)stack.get(DataComponents.QUARRY_BOUNDS)) != null && !stabilizers.isEmpty()) {
            components.add((Component)Component.literal((String)"\u00a7bLinked Stabilizer Positions"));
            for (BlockPos stabilizer : stabilizers) {
                components.add((Component)Component.literal((String)String.format(" \u00a7b  - [%s, %s, %s]", stabilizer.getX(), stabilizer.getY(), stabilizer.getZ())));
            }
        } else {
            components.add((Component)Component.literal((String)"No Linked Stabilizers. Right click a square of stabilizers to link!").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        }
        QuarryData quarryData = (QuarryData)stack.get(DataComponents.QUARRY_DATA);
        if (quarryData != null) {
            components.add((Component)Component.literal((String)String.format("%d FE Stored", quarryData.currentEnergy())));
        }
    }

    private boolean isOutside(List<BlockPos> corners, BlockPos placePosition) {
        List<Integer> xValues = corners.stream().map(Vec3i::getX).distinct().toList();
        List<Integer> zValues = corners.stream().map(Vec3i::getZ).distinct().toList();
        if (xValues.size() == 2 && zValues.size() == 2) {
            return xValues.get(0) > placePosition.getX() && xValues.get(1) > placePosition.getX() || xValues.get(0) < placePosition.getX() && xValues.get(1) < placePosition.getX() || zValues.get(0) > placePosition.getZ() && zValues.get(1) > placePosition.getZ() || zValues.get(0) < placePosition.getZ() && zValues.get(1) < placePosition.getZ();
        }
        return false;
    }

    private boolean isOneAway(List<BlockPos> corners, BlockPos placePosition) {
        for (int i = 0; i < 4; ++i) {
            if (!this.isOnLine(corners, placePosition.relative(Direction.from2DDataValue((int)i)))) continue;
            return true;
        }
        return false;
    }

    private boolean isOnLine(List<BlockPos> corners, BlockPos placePosition) {
        List<Integer> xValues = corners.stream().map(Vec3i::getX).distinct().toList();
        List<Integer> zValues = corners.stream().map(Vec3i::getZ).distinct().toList();
        return zValues.contains(placePosition.getZ()) && this.isInBetween(xValues, placePosition.getX()) || xValues.contains(placePosition.getX()) && this.isInBetween(zValues, placePosition.getZ());
    }

    private boolean isInBetween(List<Integer> ints, int value) {
        return ints.get(0) >= value && ints.get(1) <= value || ints.get(0) <= value && ints.get(1) >= value;
    }
}

