/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.FurnaceUpgrades;
import dev.willyelton.crystal_tools.common.components.GeneratorData;
import dev.willyelton.crystal_tools.common.components.GeneratorUpgrades;
import dev.willyelton.crystal_tools.common.components.LevelableBlockEntityData;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import dev.willyelton.crystal_tools.utils.StringUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class LevelableBlockItem
extends BlockItem {
    public LevelableBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        GeneratorData generatorData;
        LevelableBlockEntityData entityData = (LevelableBlockEntityData)stack.get(DataComponents.LEVELABLE_BLOCK_ENTITY_DATA);
        if (entityData != null) {
            components.add((Component)Component.literal((String)String.format("%d/%d XP To Next Level", entityData.exp(), entityData.expCap())));
            int skillPoints = entityData.skillPoints();
            if (skillPoints > 0) {
                components.add((Component)Component.literal((String)String.format("%d Unspent Skill Points", skillPoints)));
            }
        }
        if ((generatorData = (GeneratorData)stack.get(DataComponents.GENERATOR_DATA)) != null) {
            components.add((Component)Component.literal((String)String.format("%d FE Stored", generatorData.energy())));
        }
        if (!tooltipFlag.hasShiftDown()) {
            components.add((Component)Component.literal((String)"<Hold Shift For Skills>"));
        } else {
            GeneratorUpgrades generatorUpgrades;
            components.add((Component)Component.literal((String)"\u00a76Skills:"));
            FurnaceUpgrades furnaceUpgrades = (FurnaceUpgrades)stack.get(DataComponents.FURNACE_UPGRADES);
            if (furnaceUpgrades != null) {
                if (furnaceUpgrades.speed() > 0.0f) {
                    components.add((Component)Component.literal((String)String.format("\u00a76     %s: %s", "Speed", StringUtils.formatFloat(furnaceUpgrades.speed()))));
                }
                if (furnaceUpgrades.fuelEfficiency() > 0) {
                    components.add((Component)Component.literal((String)String.format("\u00a76     %s: %d", "Fuel Efficiency", furnaceUpgrades.fuelEfficiency())));
                }
                if (furnaceUpgrades.slots() > 0) {
                    components.add((Component)Component.literal((String)String.format("\u00a76     %s: %d", "Extra Slots", furnaceUpgrades.slots())));
                }
                if (furnaceUpgrades.fuelEfficiency() > 0) {
                    components.add((Component)Component.literal((String)String.format("\u00a76     %s: %d", "Extra Fuel Slots", furnaceUpgrades.fuelSlots())));
                }
                if (furnaceUpgrades.balance()) {
                    components.add((Component)Component.literal((String)"\u00a76     Auto Balance"));
                }
                if (furnaceUpgrades.saveFuel()) {
                    components.add((Component)Component.literal((String)"\u00a76     Save Fuel"));
                }
            }
            if ((generatorUpgrades = (GeneratorUpgrades)stack.get(DataComponents.GENERATOR_UPGRADES)) != null) {
                if (generatorUpgrades.feGeneration() > 0) {
                    components.add((Component)Component.literal((String)String.format("\u00a76     %s: %d", "Bonus Generation", generatorUpgrades.feGeneration())));
                }
                if (generatorUpgrades.feStorage() > 0) {
                    components.add((Component)Component.literal((String)String.format("\u00a76     %s: %d", "Bonus Capacity", generatorUpgrades.feStorage())));
                }
                if (generatorUpgrades.fuelEfficiency() > 0.0f) {
                    components.add((Component)Component.literal((String)String.format("\u00a76     %s: %s%%", "Fuel Efficiency", StringUtils.formatPercent(generatorUpgrades.fuelEfficiency()))));
                }
                if (generatorUpgrades.redstoneControl()) {
                    components.add((Component)Component.literal((String)"\u00a76     Redstone Control"));
                }
                if (generatorUpgrades.saveFuel()) {
                    components.add((Component)Component.literal((String)"\u00a76     Save Fuel"));
                }
                if (generatorUpgrades.metalGenerator()) {
                    components.add((Component)Component.literal((String)"\u00a76     Metal Generator"));
                }
                if (generatorUpgrades.foodGenerator()) {
                    components.add((Component)Component.literal((String)"\u00a76     Food Generator"));
                }
                if (generatorUpgrades.gemGenerator()) {
                    components.add((Component)Component.literal((String)"\u00a76     Gem Generator"));
                }
            }
            if (((Boolean)stack.getOrDefault(DataComponents.AUTO_OUTPUT, (Object)false)).booleanValue()) {
                components.add((Component)Component.literal((String)"\u00a76     Auto Output"));
            }
            if (((Boolean)stack.getOrDefault(DataComponents.CHUNKLOADING, (Object)false)).booleanValue()) {
                components.add((Component)Component.literal((String)"\u00a76     Chunkloading"));
            }
        }
        ItemContainerContents container = this.getContainer(stack);
        if (container != null && !container.stream().allMatch(ItemStack::isEmpty)) {
            if (!tooltipFlag.hasAltDown()) {
                components.add((Component)Component.literal((String)"<Hold Alt For Stored Items>"));
            } else {
                container.stream().forEach(storedStack -> {
                    if (!storedStack.isEmpty()) {
                        components.add((Component)Component.literal((String)ItemStackUtils.toString(storedStack)));
                    }
                });
            }
        }
    }

    @Nullable
    private ItemContainerContents getContainer(ItemStack stack) {
        ItemContainerContents container = (ItemContainerContents)stack.get(DataComponents.FURNACE_INVENTORY);
        if (container == null) {
            container = (ItemContainerContents)stack.get(net.minecraft.core.component.DataComponents.CONTAINER);
        }
        return container;
    }
}

