/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block;

import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.renderer.QuarryLaserRenderer;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.utils.Colors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class QuarryStabilizer
extends Block {
    private static final int RED = Colors.fromRGB(255, 0, 0);
    private static final int GREEN = Colors.fromRGB(0, 255, 0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0)});
    private static final List<Direction> DIRECTIONS = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);

    public QuarryStabilizer() {
        super(BlockBehaviour.Properties.of().lightLevel(state -> 14).sound(SoundType.AMETHYST).strength(5.0f, 6.0f));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        List<BlockPos> stabilizerPositions = QuarryStabilizer.findStabilizerSquare(pos, level);
        CrystalTools.LOGGER.trace(stabilizerPositions);
        if (level.isClientSide) {
            int color;
            QuarryLaserRenderer.clearTemporaryLasers();
            int n = color = stabilizerPositions.size() == 4 ? GREEN : RED;
            if (stabilizerPositions.size() > 1) {
                QuarryLaserRenderer.startTemporaryLaser(level.getGameTime(), level.getGameTime() + 200L, stabilizerPositions.get(0), stabilizerPositions.get(1), color);
            }
            if (stabilizerPositions.size() > 2) {
                QuarryLaserRenderer.startTemporaryLaser(level.getGameTime() + (long)this.timeBetweenBlocks(stabilizerPositions.get(0), stabilizerPositions.get(1)), level.getGameTime() + 200L, stabilizerPositions.get(1), stabilizerPositions.get(2), color);
            }
            if (stabilizerPositions.size() == 3) {
                BlockPos lastPos = this.findFourthPosition(stabilizerPositions);
                color = Colors.addAlpha(RED, 100);
                QuarryLaserRenderer.startTemporaryLaser(level.getGameTime(), level.getGameTime() + 200L, stabilizerPositions.get(0), lastPos, color);
                QuarryLaserRenderer.startTemporaryLaser(level.getGameTime() + (long)this.timeBetweenBlocks(stabilizerPositions.get(0), stabilizerPositions.get(1), stabilizerPositions.get(2)), level.getGameTime() + 200L, stabilizerPositions.get(2), lastPos, color);
                QuarryLaserRenderer.startTemporaryCube(level.getGameTime() + (long)this.timeBetweenBlocks(stabilizerPositions.get(0), stabilizerPositions.get(1), stabilizerPositions.get(2)), level.getGameTime() + 200L, lastPos, color);
            }
            if (stabilizerPositions.size() > 3) {
                QuarryLaserRenderer.startTemporaryLaser(level.getGameTime() + (long)this.timeBetweenBlocks(stabilizerPositions.get(0), stabilizerPositions.get(1), stabilizerPositions.get(2)), level.getGameTime() + 200L, stabilizerPositions.get(2), stabilizerPositions.get(3), color);
                QuarryLaserRenderer.startTemporaryLaser(level.getGameTime() + (long)this.timeBetweenBlocks(stabilizerPositions.get(0), stabilizerPositions.get(1), stabilizerPositions.get(2), stabilizerPositions.get(3)), level.getGameTime() + 200L, stabilizerPositions.get(3), stabilizerPositions.get(0), color);
            }
        } else if (stabilizerPositions.size() == 4 && stack.is(Registration.CRYSTAL_QUARRY_ITEM)) {
            stack.remove(DataComponents.QUARRY_DATA);
            stack.set(DataComponents.QUARRY_BOUNDS, stabilizerPositions);
            player.displayClientMessage((Component)Component.literal((String)"Stabilizer Positions Saved to Quarry"), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    private int timeBetweenBlocks(BlockPos ... positions) {
        float distance = 0.0f;
        for (int i = 0; i < positions.length - 1; ++i) {
            distance += (float)Math.sqrt(positions[i].distSqr((Vec3i)positions[i + 1]));
        }
        return (int)(distance * 1.2f);
    }

    private BlockPos findFourthPosition(List<BlockPos> positions) {
        HashMap<Integer, Integer> xMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> zMap = new HashMap<Integer, Integer>();
        for (BlockPos pos : positions) {
            xMap.compute(pos.getX(), (key, value) -> value == null ? 1 : value + 1);
            zMap.compute(pos.getZ(), (key, value) -> value == null ? 1 : value + 1);
        }
        int x = xMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).findFirst().orElse(0);
        int z = zMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).findFirst().orElse(0);
        return new BlockPos(x, positions.getFirst().getY(), z);
    }

    public static List<BlockPos> findStabilizerSquare(BlockPos startingPos, Level level) {
        ArrayList<BlockPos> foundBlocks = new ArrayList<BlockPos>();
        foundBlocks.add(startingPos);
        ArrayList<BlockPos> bestFoundBlocks = new ArrayList<BlockPos>();
        for (Direction direction : DIRECTIONS) {
            BlockPos nextStabilizer = QuarryStabilizer.findStabilizerInDirection(startingPos, direction, level);
            if (nextStabilizer == null) continue;
            foundBlocks.add(nextStabilizer);
            BlockPos tryRight = QuarryStabilizer.findStabilizerInDirection(nextStabilizer, direction.getClockWise(), level);
            if (tryRight != null) {
                foundBlocks.add(tryRight);
                BlockPos finalPosition = direction.getAxis() == Direction.Axis.X ? new BlockPos(startingPos.getX(), startingPos.getY(), tryRight.getZ()) : new BlockPos(tryRight.getX(), startingPos.getY(), startingPos.getZ());
                if (level.getBlockState(finalPosition).getBlock() instanceof QuarryStabilizer) {
                    return List.of(startingPos, nextStabilizer, tryRight, finalPosition);
                }
            } else {
                BlockPos tryLeft = QuarryStabilizer.findStabilizerInDirection(nextStabilizer, direction.getCounterClockWise(), level);
                if (tryLeft != null) {
                    foundBlocks.add(tryLeft);
                    BlockPos finalPosition = direction.getAxis() == Direction.Axis.X ? new BlockPos(startingPos.getX(), startingPos.getY(), tryLeft.getZ()) : new BlockPos(tryLeft.getX(), startingPos.getY(), startingPos.getZ());
                    if (level.getBlockState(finalPosition).getBlock() instanceof QuarryStabilizer) {
                        return List.of(startingPos, nextStabilizer, tryLeft, finalPosition);
                    }
                }
            }
            if (bestFoundBlocks.size() < foundBlocks.size()) {
                bestFoundBlocks = foundBlocks;
            }
            foundBlocks = new ArrayList();
        }
        return bestFoundBlocks;
    }

    @Nullable
    private static BlockPos findStabilizerInDirection(BlockPos startingPos, Direction direction, Level level) {
        for (int i = 1; i < (Integer)CrystalToolsConfig.QUARRY_MAX_SIZE.get(); ++i) {
            if (!(level.getBlockState(startingPos.relative(direction, i)).getBlock() instanceof QuarryStabilizer)) continue;
            return startingPos.relative(direction, i);
        }
        return null;
    }
}

