/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ActionBlockEntity
extends BlockEntity {
    private static final Codec<Map<ActionType, ActionParameters>> SAVED_ACTIONS_CODEC = Codec.unboundedMap(ActionType.CODEC, ActionParameters.CODEC);
    private final Map<ActionType, Action> actions = new HashMap<ActionType, Action>();
    private final Map<ActionType, ActionParameters> savedActions = new HashMap<ActionType, ActionParameters>();

    public ActionBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.getDefaultActions().forEach(action -> this.actions.put(action.getActionType(), (Action)action));
    }

    public void onBlockRemoved() {
        for (Action action : this.getActions()) {
            action.onRemove();
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.getActions().forEach(action -> action.load(tag, registries));
        if (tag.contains("SavedActions")) {
            SAVED_ACTIONS_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("SavedActions")).ifSuccess(actions -> this.savedActions.putAll((Map)actions.getFirst()));
        }
        this.savedActions.forEach((type, parameters) -> {
            Action action = type.getActionInstance(this, (ActionParameters)parameters);
            if (action != null) {
                this.actions.put((ActionType)((Object)type), action);
            } else {
                CrystalTools.LOGGER.warn("Saved action parameters created null action {} {}", (Object)type, parameters);
            }
        });
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        for (Action action : this.getActions()) {
            action.applyComponents(componentInput);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.getActions().forEach(action -> action.save(tag, registries));
        SAVED_ACTIONS_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.savedActions).ifSuccess(t -> tag.put("savedActions", t));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        for (Action action : this.getActions()) {
            action.collectComponents(components);
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        for (Action action : this.getActions()) {
            action.tick(level, pos, state);
        }
    }

    protected <T extends Action> void addAction(T action, ActionParameters parameters) {
        this.actions.put(action.getActionType(), action);
        this.savedActions.put(action.getActionType(), parameters);
        this.setChanged();
    }

    protected void removeAction(ActionType actionType) {
        if (this.actions.containsKey((Object)actionType)) {
            this.actions.get((Object)actionType).onRemove();
            this.actions.remove((Object)actionType);
            this.savedActions.remove((Object)actionType);
            this.setChanged();
        }
    }

    protected boolean hasAction(ActionType actionType) {
        return this.actions.containsKey((Object)actionType);
    }

    protected Action getAction(ActionType actionType) {
        return this.actions.get((Object)actionType);
    }

    protected Iterable<Action> getActions() {
        return this.actions.values();
    }

    protected Collection<Action> getDefaultActions() {
        return List.of();
    }
}

