/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.GeneratorData;
import dev.willyelton.crystal_tools.common.components.GeneratorUpgrades;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.datamap.DataMaps;
import dev.willyelton.crystal_tools.common.datamap.GeneratorFuelData;
import dev.willyelton.crystal_tools.common.energy.CrystalEnergyStorage;
import dev.willyelton.crystal_tools.common.inventory.GeneratorItemStackHandler;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalGeneratorContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalFurnaceBlock;
import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.LevelableContainerData;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CrystalGeneratorBlockEntity
extends LevelableBlockEntity
implements MenuProvider {
    public static final int DATA_SIZE = 5;
    private static final int SIZE = 1;
    private NonNullList<ItemStack> fuelItems;
    private IItemHandler fuelHandler;
    private CrystalEnergyStorage energyStorage;
    private final int baseFEStorage;
    private final int baseFETransfer;
    private float addedFEGeneration = 0.0f;
    private float fuelEfficiency = 0.0f;
    private float addedFEStorage = 0.0f;
    private boolean redstoneControl = false;
    private boolean saveFuel = false;
    private boolean metalGenerator = false;
    private boolean foodGenerator = false;
    private boolean gemGenerator = false;
    private int litTime;
    private int litTotalTime;
    private ItemStack burnedItem = ItemStack.EMPTY;
    protected final ContainerData dataAccess = new LevelableContainerData(this){

        @Override
        protected int getExtra(int index) {
            return switch (index) {
                case 3 -> CrystalGeneratorBlockEntity.this.litTime;
                case 4 -> CrystalGeneratorBlockEntity.this.litTotalTime;
                case 5 -> CrystalGeneratorBlockEntity.this.energyStorage.getEnergyStored();
                case 6 -> CrystalGeneratorBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 7 -> {
                    if (CrystalGeneratorBlockEntity.this.litTime > 0) {
                        yield CrystalGeneratorBlockEntity.this.getGeneration(CrystalGeneratorBlockEntity.this.burnedItem);
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        @Override
        protected void setExtra(int index, int value) {
            switch (index) {
                case 3: {
                    CrystalGeneratorBlockEntity.this.litTime = value;
                    break;
                }
                case 4: {
                    CrystalGeneratorBlockEntity.this.litTotalTime = value;
                }
            }
        }

        @Override
        protected int getExtraDataSize() {
            return 5;
        }
    };

    public CrystalGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CRYSTAL_GENERATOR_BLOCK_ENTITY.get(), pos, state);
        this.fuelItems = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        this.fuelHandler = new GeneratorItemStackHandler(this.fuelItems, this);
        this.baseFEStorage = (Integer)CrystalToolsConfig.BASE_FE_STORAGE.get();
        this.baseFETransfer = (Integer)CrystalToolsConfig.BASE_FE_TRANSFER.get();
        this.energyStorage = new CrystalEnergyStorage(this.baseFEStorage, 0, this.baseFETransfer, 0);
    }

    public IItemHandler getItemHandlerCapForSide(Direction side) {
        return this.fuelHandler;
    }

    public IEnergyStorage getEnergyStorageCapForSide(Direction side) {
        return this.energyStorage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.crystal_tools.crystal_generator");
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CrystalGeneratorContainerMenu(containerId, player.level(), this.getBlockPos(), playerInventory, this.dataAccess);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.fuelItems, (HolderLookup.Provider)registries);
        this.litTime = tag.getInt("LitTime");
        this.litTotalTime = tag.getInt("LitTotalTime");
        if (tag.contains("BurnedItem")) {
            this.burnedItem = ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.get("BurnedItem")).orElse(ItemStack.EMPTY);
        }
        this.addedFEGeneration = tag.getFloat("AddedFEGeneration");
        this.fuelEfficiency = tag.getFloat("FuelEfficiency");
        this.addedFEStorage = tag.getFloat("AddedFEStorage");
        this.redstoneControl = tag.getBoolean("RedstoneControl");
        this.saveFuel = tag.getBoolean("SaveFuel");
        this.metalGenerator = tag.getBoolean("MetalGenerator");
        this.foodGenerator = tag.getBoolean("FoodGenerator");
        this.gemGenerator = tag.getBoolean("GemGenerator");
        int energy = tag.getInt("Energy");
        this.energyStorage = new CrystalEnergyStorage(this.baseFEStorage + (int)this.addedFEStorage, 0, this.baseFETransfer + (int)this.addedFEGeneration * 2, energy);
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        GeneratorData generatorData;
        GeneratorUpgrades generatorUpgrades;
        super.applyImplicitComponents(componentInput);
        ItemContainerContents contents = (ItemContainerContents)componentInput.get(net.minecraft.core.component.DataComponents.CONTAINER);
        this.fuelItems = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        this.fuelHandler = new GeneratorItemStackHandler(this.fuelItems, this);
        if (contents != null) {
            contents.copyInto(this.fuelItems);
        }
        if ((generatorUpgrades = (GeneratorUpgrades)componentInput.get(DataComponents.GENERATOR_UPGRADES)) != null) {
            this.addedFEGeneration = generatorUpgrades.feGeneration();
            this.fuelEfficiency = generatorUpgrades.fuelEfficiency();
            this.addedFEStorage = generatorUpgrades.feStorage();
            this.redstoneControl = generatorUpgrades.redstoneControl();
            this.saveFuel = generatorUpgrades.saveFuel();
            this.metalGenerator = generatorUpgrades.metalGenerator();
            this.foodGenerator = generatorUpgrades.foodGenerator();
            this.gemGenerator = generatorUpgrades.gemGenerator();
        }
        if ((generatorData = (GeneratorData)componentInput.get(DataComponents.GENERATOR_DATA)) != null) {
            this.litTime = generatorData.litTime();
            this.litTotalTime = generatorData.litTotalTime();
            this.burnedItem = generatorData.burnedItem().copy();
            int energy = generatorData.energy();
            this.energyStorage = new CrystalEnergyStorage(this.baseFEStorage + (int)this.addedFEStorage, 0, this.baseFETransfer + (int)this.addedFEGeneration * 2, energy);
        } else {
            this.energyStorage = new CrystalEnergyStorage(this.baseFEStorage + (int)this.addedFEStorage, 0, this.baseFETransfer + (int)this.addedFEGeneration * 2, 0);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.fuelItems, (HolderLookup.Provider)registries);
        tag.putInt("LitTime", this.litTime);
        tag.putInt("LitTotalTime", this.litTotalTime);
        if (!this.burnedItem.isEmpty()) {
            tag.put("BurnedItem", this.burnedItem.save(registries));
        }
        tag.putFloat("AddedFEGeneration", this.addedFEGeneration);
        tag.putFloat("FuelEfficiency", this.fuelEfficiency);
        tag.putFloat("AddedFEStorage", this.addedFEStorage);
        tag.putBoolean("RedstoneControl", this.redstoneControl);
        tag.putBoolean("SaveFuel", this.saveFuel);
        tag.putBoolean("MetalGenerator", this.metalGenerator);
        tag.putBoolean("FoodGenerator", this.foodGenerator);
        tag.putBoolean("GemGenerator", this.gemGenerator);
        tag.putInt("Energy", this.energyStorage.getEnergyStored());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        ItemContainerContents contents = ItemContainerContents.fromItems(this.fuelItems);
        components.set(net.minecraft.core.component.DataComponents.CONTAINER, (Object)contents);
        GeneratorUpgrades generatorUpgrades = new GeneratorUpgrades((int)this.addedFEGeneration, this.fuelEfficiency, (int)this.addedFEStorage, this.redstoneControl, this.saveFuel, this.metalGenerator, this.foodGenerator, this.gemGenerator);
        components.set(DataComponents.GENERATOR_UPGRADES, (Object)generatorUpgrades);
        GeneratorData generatorData = new GeneratorData(this.litTime, this.litTotalTime, this.burnedItem.copy(), this.energyStorage.getEnergyStored());
        components.set(DataComponents.GENERATOR_DATA, (Object)generatorData);
    }

    @Override
    protected void addToExtraData(String key, float value) {
        switch (key) {
            case "fe_generation": {
                float generationToAdd = value * (float)((Integer)CrystalToolsConfig.FE_GENERATION_PER_LEVEL.get()).intValue();
                this.addedFEGeneration += generationToAdd;
                this.energyStorage.setMaxExtract(this.energyStorage.getMaxExtract() + (int)generationToAdd * 2);
                break;
            }
            case "fuel_efficiency": {
                this.fuelEfficiency += value;
                break;
            }
            case "fe_capacity": {
                float storageToAdd = value * (float)((Integer)CrystalToolsConfig.FE_STORAGE_PER_LEVEL.get()).intValue();
                this.addedFEStorage += storageToAdd;
                this.energyStorage.setCapacity(this.energyStorage.getMaxEnergyStored() + (int)storageToAdd);
                break;
            }
            case "redstone_control": {
                this.redstoneControl = value == 1.0f;
                break;
            }
            case "save_fuel": {
                this.saveFuel = value == 1.0f;
                break;
            }
            case "metal_generator": {
                this.metalGenerator = value == 1.0f;
                break;
            }
            case "food_generator": {
                this.foodGenerator = value == 1.0f;
                break;
            }
            case "gem_generator": {
                this.gemGenerator = value == 1.0f;
            }
        }
    }

    @Override
    protected void resetExtraSkills() {
        this.addedFEGeneration = 0.0f;
        this.energyStorage = new CrystalEnergyStorage(this.baseFEStorage, 0, this.baseFETransfer, Math.max(this.energyStorage.getEnergyStored(), this.baseFEStorage));
        this.fuelEfficiency = 0.0f;
        this.addedFEStorage = 0.0f;
        this.redstoneControl = false;
        this.saveFuel = false;
        this.metalGenerator = false;
        this.foodGenerator = false;
        this.gemGenerator = false;
    }

    @Override
    protected int getBaseExpCap() {
        return (Integer)CrystalToolsConfig.GENERATOR_BASE_EXPERIENCE_CAP.get();
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        int generation;
        ItemStack fuelItemStack;
        boolean hasFuel;
        boolean hasRedstone = level.hasNeighborSignal(pos);
        if (hasRedstone && this.redstoneControl) {
            return;
        }
        boolean wasLit = this.isLit();
        boolean needsChange = false;
        if (wasLit) {
            boolean canFitEnergy;
            boolean bl = canFitEnergy = this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored() >= this.getGeneration(ItemStack.EMPTY);
            if (canFitEnergy || !this.saveFuel) {
                --this.litTime;
                if (this.litTime <= 0) {
                    this.burnedItem = ItemStack.EMPTY;
                    needsChange = true;
                }
            }
        }
        boolean bl = hasFuel = !(fuelItemStack = (ItemStack)this.fuelItems.getFirst()).isEmpty();
        if (!this.isLit() && hasFuel) {
            this.litTotalTime = this.litTime = this.getBurnDuration(fuelItemStack);
            this.burnedItem = fuelItemStack.copy();
            if (this.isLit()) {
                needsChange = true;
                this.addSkillExpFromBurn(this.litTotalTime);
                if (fuelItemStack.hasCraftingRemainingItem()) {
                    this.fuelItems.set(0, (Object)fuelItemStack.getCraftingRemainingItem());
                } else {
                    fuelItemStack.shrink(1);
                    if (fuelItemStack.isEmpty()) {
                        this.fuelItems.set(0, (Object)fuelItemStack.getCraftingRemainingItem());
                    }
                }
            }
        }
        if (this.isLit() && this.energyStorage.canAdd(generation = this.getGeneration(this.burnedItem))) {
            this.energyStorage.addEnergy(generation);
        }
        this.distributeEnergy(level, pos);
        if (wasLit != this.isLit()) {
            needsChange = true;
            state = (BlockState)state.setValue((Property)CrystalFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            level.setBlock(pos, state, 3);
        }
        if (needsChange) {
            CrystalGeneratorBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void distributeEnergy(Level level, BlockPos pos) {
        int amountPerBlock;
        ArrayList<IEnergyStorage> possibleDestinations = new ArrayList<IEnergyStorage>();
        for (Direction direction : Direction.values()) {
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
            if (energyStorage == null || !energyStorage.canReceive()) continue;
            possibleDestinations.add(energyStorage);
        }
        if (possibleDestinations.isEmpty()) {
            return;
        }
        int amountToTransfer = Math.min(this.baseFETransfer + (int)this.addedFEGeneration * 2, this.energyStorage.getEnergyStored());
        int amountAdded = 0;
        boolean didTransfer = true;
        while (amountAdded < amountToTransfer && !possibleDestinations.isEmpty() && didTransfer && ((amountPerBlock = (amountToTransfer - amountAdded) / possibleDestinations.size()) != 0 || (amountPerBlock = (amountToTransfer - amountAdded) % possibleDestinations.size()) != 0)) {
            didTransfer = false;
            Iterator itr = possibleDestinations.iterator();
            while (itr.hasNext() && amountAdded < amountToTransfer) {
                IEnergyStorage storage = (IEnergyStorage)itr.next();
                int added = storage.receiveEnergy(amountPerBlock, false);
                if (added > 0) {
                    didTransfer = true;
                }
                amountAdded += added;
                if (added == amountPerBlock) continue;
                itr.remove();
            }
        }
        this.energyStorage.extractEnergy(amountAdded, false);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public int getBurnDuration(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        GeneratorFuelData fuelData = this.getFuelData(stack);
        if (fuelData != null) {
            return (int)((float)fuelData.burnTime() * (1.0f + this.fuelEfficiency));
        }
        return (int)((float)stack.getBurnTime(null) * (1.0f + this.fuelEfficiency));
    }

    private int getGeneration(ItemStack burnedStack) {
        GeneratorFuelData fuelData = this.getFuelData(burnedStack);
        int bonusGeneration = fuelData == null ? 0 : fuelData.bonusGeneration();
        return (Integer)CrystalToolsConfig.BASE_FE_GENERATION.get() + (int)this.addedFEGeneration + bonusGeneration;
    }

    @Nullable
    private GeneratorFuelData getFuelData(ItemStack stack) {
        return CrystalGeneratorBlockEntity.getFuelData(stack, this.foodGenerator, this.metalGenerator, this.gemGenerator);
    }

    @Nullable
    public static GeneratorFuelData getFuelData(ItemStack stack, boolean foodGenerator, boolean metalGenerator, boolean gemGenerator) {
        GeneratorFuelData data;
        FoodProperties foodData;
        if (stack.isEmpty()) {
            return null;
        }
        if (foodGenerator && (foodData = stack.getFoodProperties(null)) != null) {
            return new GeneratorFuelData(CrystalGeneratorBlockEntity.getBurnTimeFromFood(foodData), 0);
        }
        if (metalGenerator && (data = (GeneratorFuelData)stack.getItemHolder().getData(DataMaps.GENERATOR_METALS)) != null) {
            return data;
        }
        if (gemGenerator) {
            return (GeneratorFuelData)stack.getItemHolder().getData(DataMaps.GENERATOR_GEMS);
        }
        return null;
    }

    private void addSkillExpFromBurn(int burnTime) {
        this.addExp((int)Math.ceil((Double)CrystalToolsConfig.SKILL_POINTS_PER_BURN_TIME.get() * (double)burnTime));
    }

    public IItemHandler getFuelHandler() {
        return this.fuelHandler;
    }

    public static int getBurnTimeFromFood(FoodProperties foodProperties) {
        return (int)((Double)CrystalToolsConfig.FOOD_BURN_TIME_MULTIPLIER.get() * (double)((float)foodProperties.nutrition() + foodProperties.saturation()));
    }
}

