/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity;

import com.mojang.serialization.DynamicOps;
import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.datamap.ActionData;
import dev.willyelton.crystal_tools.common.datamap.DataMaps;
import dev.willyelton.crystal_tools.common.inventory.CallbackItemStackHandler;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalPedestalContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalPedestalBlock;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.PedestalClientData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CrystalPedestalBlockEntity
extends ActionBlockEntity
implements MenuProvider {
    private final PedestalClientData clientData = new PedestalClientData();
    private final IItemHandler catalystHandler;
    private final IItemHandler contentsHandler;
    private final NonNullList<ItemStack> catalystStacks = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> contentsStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);

    public CrystalPedestalBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)Registration.CRYSTAL_PEDESTAL_BLOCK_ENTITY.get(), pos, blockState);
        this.catalystHandler = new CallbackItemStackHandler(this.catalystStacks, this::setStack);
        this.contentsHandler = new ItemStackHandler(this.contentsStacks);
    }

    public IItemHandler getItemHandlerCapForSide(Direction side) {
        if (this.getBlockState().getValue(CrystalPedestalBlock.FACING) == side) {
            return this.catalystHandler;
        }
        return this.contentsHandler;
    }

    public IItemHandler getContentsHandler() {
        return this.contentsHandler;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("item")) {
            ItemStack.OPTIONAL_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("item")).ifSuccess(p -> this.catalystStacks.set(0, (Object)((ItemStack)p.getFirst())));
        }
        ContainerHelper.loadAllItems((CompoundTag)tag, this.contentsStacks, (HolderLookup.Provider)registries);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((ItemStack)this.catalystStacks.getFirst())).ifSuccess(p -> tag.put("item", p));
        ContainerHelper.saveAllItems((CompoundTag)tag, this.contentsStacks, (HolderLookup.Provider)registries);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.clientData.update();
    }

    public ItemStack setStack(ItemStack stack) {
        if (this.level == null) {
            return stack;
        }
        ItemStack storedStack = (ItemStack)this.catalystStacks.getFirst();
        this.catalystStacks.set(0, (Object)stack);
        this.setStack(stack, storedStack);
        return storedStack;
    }

    private void setStack(ItemStack newStack, ItemStack oldStack) {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        this.setActions(newStack, oldStack);
        this.setChanged();
    }

    private void setActions(ItemStack newStack, ItemStack oldStack) {
        ActionData actionData;
        ActionData oldActionData = (ActionData)oldStack.getItemHolder().getData(DataMaps.PEDESTAL_ACTIONS);
        if (oldActionData != null) {
            this.removeAction(oldActionData.type());
        }
        if ((actionData = (ActionData)newStack.getItemHolder().getData(DataMaps.PEDESTAL_ACTIONS)) != null) {
            this.addAction(actionData.type().getActionInstance(this, actionData.params()), actionData.params());
        }
    }

    @Nullable
    public ItemStack getStack() {
        return (ItemStack)this.catalystStacks.getFirst();
    }

    public PedestalClientData getClientData() {
        return this.clientData;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.crystal_tools.crystal_pedestal");
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CrystalPedestalContainerMenu(containerId, playerInventory, this.getBlockPos());
    }

    public void dropContents(Level level, BlockPos pos) {
        Containers.dropContents((Level)level, (BlockPos)pos, this.catalystStacks);
        Containers.dropContents((Level)level, (BlockPos)pos, this.contentsStacks);
    }
}

