/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.LevelableBlockEntityData;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.utils.NBTUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LevelableBlockEntity
extends ActionBlockEntity {
    public static final List<String> NBT_TAGS = List.of("SkillPoints", "Points", "Exp", "ExpCap");
    protected int skillPoints = 0;
    protected int[] points = new int[100];
    protected int exp = 0;
    protected int expCap = this.getExpCap();

    public LevelableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.skillPoints = tag.getInt("SkillPoints");
        this.points = NBTUtils.getIntArray(tag, "Points", 100);
        this.exp = tag.getInt("Exp");
        this.expCap = tag.getInt("ExpCap");
        if (this.expCap == 0) {
            this.expCap = this.getBaseExpCap();
        }
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        LevelableBlockEntityData levelableBlockEntityData = (LevelableBlockEntityData)componentInput.get(DataComponents.LEVELABLE_BLOCK_ENTITY_DATA);
        if (levelableBlockEntityData != null) {
            this.skillPoints = levelableBlockEntityData.skillPoints();
            this.points = levelableBlockEntityData.points().stream().mapToInt(Integer::intValue).toArray();
            this.exp = levelableBlockEntityData.exp();
            this.expCap = levelableBlockEntityData.expCap();
        }
        if (this.expCap == 0) {
            this.expCap = this.getBaseExpCap();
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("SkillPoints", this.skillPoints);
        tag.putIntArray("Points", this.points);
        tag.putInt("Exp", this.exp);
        tag.putInt("ExpCap", this.expCap);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        LevelableBlockEntityData levelableBlockEntityData = new LevelableBlockEntityData(this.skillPoints, Arrays.stream(this.points).boxed().toList(), this.exp, this.expCap);
        components.set(DataComponents.LEVELABLE_BLOCK_ENTITY_DATA, (Object)levelableBlockEntityData);
    }

    public void addSkillPoints(int points) {
        this.skillPoints += points;
        this.setChanged();
    }

    public void addToData(String key, float value) {
        for (Action action : this.getActions()) {
            if (!action.addToExtra(key, value)) continue;
            this.setChanged();
            return;
        }
        switch (key) {
            case "skill_points": {
                this.skillPoints += (int)value;
                break;
            }
            case "experience": {
                this.exp += (int)value;
                break;
            }
            case "experience_cap": {
                this.expCap += (int)value;
                break;
            }
            default: {
                this.addToExtraData(key, value);
            }
        }
        this.setChanged();
    }

    protected abstract void addToExtraData(String var1, float var2);

    public void addToPoints(int id, int value) {
        int n = id;
        this.points[n] = this.points[n] + value;
        this.setChanged();
    }

    protected void addExp(int toAdd) {
        this.exp += toAdd;
        while (this.exp > this.expCap) {
            this.exp -= this.expCap;
            this.expCap = ToolUtils.getNewCap(this.expCap, 1);
            ++this.skillPoints;
        }
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
    }

    public int getPoint(int index) {
        return this.points[index];
    }

    public void setPoints(int index, int value) {
        this.points[index] = value;
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int exp) {
        this.exp = exp;
    }

    public int getExpCap() {
        return this.expCap;
    }

    public void setExpCap(int expCap) {
        this.expCap = expCap;
    }

    public void resetSkills() {
        this.skillPoints += (int)Arrays.stream(this.points).asLongStream().sum();
        this.points = new int[100];
        this.exp = 0;
        this.expCap = this.getBaseExpCap();
        this.resetExtraSkills();
    }

    protected void resetExtraSkills() {
        for (Action action : this.getActions()) {
            action.resetExtra();
        }
    }

    protected int getBaseExpCap() {
        return (Integer)CrystalToolsConfig.BASE_EXPERIENCE_CAP.get();
    }
}

