/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.action;

import com.google.common.primitives.Floats;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalPedestalBlock;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionType;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBreakAction
extends Action {
    private final float[] breakProgress;
    List<ItemStack> noFit = new ArrayList<ItemStack>();

    public BlockBreakAction(ActionBlockEntity blockEntity, @Nullable ActionParameters params) {
        super(blockEntity, params);
        int bonusRange = Mth.floor((double)this.getItem().getAttributeModifiers().modifiers().stream().filter(e -> e.attribute().is(Attributes.BLOCK_INTERACTION_RANGE)).findFirst().map(e -> e.modifier().amount()).orElse(0.0));
        int range = (params == null ? this.getDefaultParameters().range() : params.range()) + bonusRange;
        this.breakProgress = new float[range + 1];
    }

    @Override
    public void tickAction(@NotNull Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue(CrystalPedestalBlock.FACING);
        if (!this.noFit.isEmpty()) {
            IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
            if (handler != null) {
                this.noFit = InventoryUtils.tryInsertStacks(handler, this.noFit);
                if (!this.noFit.isEmpty()) {
                    return;
                }
            } else {
                this.dropItems(level, pos.relative(facing), this.noFit);
            }
        }
        for (int i = 0; i < this.breakProgress.length; ++i) {
            int durabilityToUse;
            BlockPos miningPos = pos.relative(facing, i + 1);
            ItemStack stack = this.getItem();
            if (ToolUtils.willBreak(stack, durabilityToUse = Mth.ceil((float)this.params.durabilityModifier())) || stack.isEmpty()) {
                return;
            }
            BlockState miningState = level.getBlockState(miningPos);
            if (miningState.requiresCorrectToolForDrops() && !stack.isCorrectToolForDrops(miningState) || miningState.isAir()) continue;
            float miningSpeed = stack.getDestroySpeed(miningState);
            float destroySpeed = state.getDestroySpeed((BlockGetter)level, pos);
            if (destroySpeed == -1.0f) continue;
            int n = i;
            this.breakProgress[n] = this.breakProgress[n] + miningSpeed / destroySpeed / 30.0f;
            level.destroyBlockProgress(-1 - i, miningPos, (int)(this.breakProgress[i] * 10.0f));
            if (this.breakProgress[i] >= 1.0f) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>(Block.getDrops((BlockState)miningState, (ServerLevel)((ServerLevel)level), (BlockPos)miningPos, (BlockEntity)level.getBlockEntity(miningPos), null, (ItemStack)stack));
                IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
                if (handler != null) {
                    this.noFit = InventoryUtils.tryInsertStacks(handler, drops);
                } else {
                    this.dropItems(level, miningPos, drops);
                }
                level.destroyBlock(miningPos, false);
                stack.hurtAndBreak(durabilityToUse, (ServerLevel)level, null, item -> {});
                Item item2 = stack.getItem();
                if (item2 instanceof LevelableItem) {
                    LevelableItem levelableItem = (LevelableItem)item2;
                    if (((Boolean)CrystalToolsConfig.LEVEL_ITEMS_IN_PEDESTAL.get()).booleanValue()) {
                        levelableItem.addExp(stack, level, pos, null);
                    }
                }
                this.breakProgress[i] = 0.0f;
            }
            if (!this.noFit.isEmpty()) break;
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.BLOCK_BREAK;
    }

    @Override
    public ActionParameters getDefaultParameters() {
        return new ActionParameters(1);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void save(CompoundTag tag, HolderLookup.Provider registries) {
        Codec.FLOAT.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)Floats.asList((float[])this.breakProgress)).ifSuccess(t -> tag.put("breakProgress", t));
        ItemStack.OPTIONAL_CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.noFit).ifSuccess(t -> tag.put("NoFit", t));
    }

    @Override
    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        Codec.FLOAT.listOf().decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("breakProgress")).ifSuccess(p -> {
            for (int i = 0; i < this.breakProgress.length; ++i) {
                if (((List)p.getFirst()).size() <= i) continue;
                this.breakProgress[i] = ((Float)((List)p.getFirst()).get(i)).floatValue();
            }
        });
        ItemStack.OPTIONAL_CODEC.listOf().decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("NoFit")).ifSuccess(p -> {
            this.noFit = (List)p.getFirst();
        });
    }

    @Override
    public void onRemove() {
        if (this.blockEntity.getLevel() == null) {
            return;
        }
        this.dropItems(this.blockEntity.getLevel(), this.blockEntity.getBlockPos(), this.noFit);
        for (int i = 0; i < this.breakProgress.length; ++i) {
            this.blockEntity.getLevel().destroyBlockProgress(-1 - i, this.blockEntity.getBlockPos().relative((Direction)this.blockEntity.getBlockState().getValue(CrystalPedestalBlock.FACING), i + 1), -1);
        }
    }

    private void dropItems(Level level, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
        }
        stacks.clear();
    }
}

