/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.data;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.ILevelableContainerData;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public abstract class ItemStackLevelableContainerData
implements ILevelableContainerData {
    protected static final int DATA_SIZE = 3;
    private final ItemStack stack;

    public ItemStackLevelableContainerData(ItemStack stack) {
        this.stack = stack;
    }

    public int get(int index) {
        return switch (index) {
            case 0 -> (Integer)this.stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
            case 1 -> (Integer)this.stack.getOrDefault(DataComponents.SKILL_EXPERIENCE, (Object)0);
            case 2 -> (Integer)this.stack.getOrDefault(DataComponents.EXPERIENCE_CAP, (Object)((Integer)CrystalToolsConfig.BASE_EXPERIENCE_CAP.get()));
            default -> index >= this.getNonSkillDataSize() && index < this.getCount() ? this.getPoint(index - this.getNonSkillDataSize()) : this.getExtra(index);
        };
    }

    protected abstract int getExtra(int var1);

    public void set(int index, int value) {
        switch (index) {
            case 0: {
                this.stack.set(DataComponents.SKILL_POINTS, (Object)value);
                break;
            }
            case 1: {
                this.stack.set(DataComponents.SKILL_EXPERIENCE, (Object)value);
                break;
            }
            case 2: {
                this.stack.set(DataComponents.EXPERIENCE_CAP, (Object)value);
                break;
            }
            default: {
                if (index >= this.getNonSkillDataSize() && index < this.getCount()) {
                    DataComponents.addValueToArray(this.stack, DataComponents.POINTS_ARRAY, index - this.getNonSkillDataSize(), value);
                    break;
                }
                this.setExtra(index, value);
            }
        }
    }

    protected abstract void setExtra(int var1, int var2);

    public int getCount() {
        return this.getNonSkillDataSize() + 100;
    }

    protected abstract int getExtraDataSize();

    private int getNonSkillDataSize() {
        return this.getExtraDataSize() + 3;
    }

    @Override
    public int getSkillPoints() {
        return (Integer)this.stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
    }

    @Override
    public void addSkillPoints(int points) {
        this.stack.set(DataComponents.SKILL_POINTS, (Object)(points + this.getSkillPoints()));
    }

    @Override
    public void addToPoints(int nodeId, int value) {
        DataComponents.addValueToArray(this.stack, DataComponents.POINTS_ARRAY, nodeId, value);
    }

    @Override
    public int getExp() {
        return (Integer)this.stack.getOrDefault(DataComponents.SKILL_EXPERIENCE, (Object)0);
    }

    @Override
    public int getExpCap() {
        return (Integer)this.stack.getOrDefault(DataComponents.EXPERIENCE_CAP, (Object)0);
    }

    @Override
    public int[] getPoints() {
        List points = (List)this.stack.get(DataComponents.POINTS_ARRAY);
        if (points == null) {
            return new int[100];
        }
        return points.stream().mapToInt(Integer::valueOf).toArray();
    }

    private int getPoint(int index) {
        int[] points = this.getPoints();
        if (index >= points.length) {
            return 0;
        }
        return points[index];
    }
}

