/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.data;

import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.ILevelableContainerData;

public abstract class LevelableContainerData
implements ILevelableContainerData {
    protected static final int DATA_SIZE = 3;
    private final LevelableBlockEntity levelableBlockEntity;

    public LevelableContainerData(LevelableBlockEntity levelableBlockEntity) {
        this.levelableBlockEntity = levelableBlockEntity;
    }

    public int get(int index) {
        return switch (index) {
            case 0 -> this.levelableBlockEntity.getSkillPoints();
            case 1 -> this.levelableBlockEntity.getExp();
            case 2 -> this.levelableBlockEntity.getExpCap();
            default -> index >= this.getNonSkillDataSize() && index < this.getCount() ? this.levelableBlockEntity.getPoint(index - this.getNonSkillDataSize()) : this.getExtra(index);
        };
    }

    protected abstract int getExtra(int var1);

    public void set(int index, int value) {
        switch (index) {
            case 0: {
                this.levelableBlockEntity.setSkillPoints(value);
                break;
            }
            case 1: {
                this.levelableBlockEntity.setExp(value);
                break;
            }
            case 2: {
                this.levelableBlockEntity.setExpCap(value);
                break;
            }
            default: {
                if (index >= this.getNonSkillDataSize() && index < this.getCount()) {
                    this.levelableBlockEntity.setPoints(index - this.getNonSkillDataSize(), value);
                    break;
                }
                this.setExtra(index, value);
            }
        }
    }

    protected abstract void setExtra(int var1, int var2);

    public int getCount() {
        return this.getNonSkillDataSize() + 100;
    }

    @Override
    public int getSkillPoints() {
        return this.get(0);
    }

    @Override
    public void addSkillPoints(int points) {
        this.set(0, this.getSkillPoints() + points);
    }

    @Override
    public void addToPoints(int nodeId, int value) {
        int index = nodeId + this.getNonSkillDataSize();
        this.set(index, this.get(index) + value);
    }

    @Override
    public int getExp() {
        return this.get(1);
    }

    @Override
    public int getExpCap() {
        return this.get(2);
    }

    @Override
    public int[] getPoints() {
        int[] result = new int[100];
        for (int i = 0; i < 100; ++i) {
            result[i] = this.get(i + this.getNonSkillDataSize());
        }
        return result;
    }

    protected abstract int getExtraDataSize();

    private int getNonSkillDataSize() {
        return this.getExtraDataSize() + 3;
    }
}

