/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillDataNode;
import dev.willyelton.crystal_tools.utils.ListUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class SkillData {
    private final List<List<SkillDataNode>> nodes;
    private List<SkillDataNode> flatNodes = null;
    private int totalPoints;
    public static final Codec<SkillData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SkillDataNode.CODEC.listOf().listOf().fieldOf("tiers").forGetter(SkillData::getAllNodesByTier)).apply((Applicative)instance, SkillData::new));
    public static final StreamCodec<ByteBuf, SkillData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    private SkillData(List<List<SkillDataNode>> nodes) {
        this.nodes = nodes;
    }

    public void applyPoints(int[] points) {
        List<SkillDataNode> nodes = this.getAllNodes();
        for (SkillDataNode node : nodes) {
            node.setPoints(points[node.getId()]);
        }
        this.totalPoints = Arrays.stream(points).sum();
    }

    public void applyPoints(List<Integer> points) {
        List<SkillDataNode> nodes = this.getAllNodes();
        for (SkillDataNode node : nodes) {
            if (points.size() > node.getId()) {
                node.setPoints(points.get(node.getId()));
                continue;
            }
            node.setPoints(0);
        }
        this.totalPoints = points.stream().mapToInt(Integer::intValue).sum();
    }

    public List<List<SkillDataNode>> getAllNodesByTier() {
        return this.nodes;
    }

    public List<SkillDataNode> getAllNodes() {
        if (this.flatNodes == null) {
            this.flatNodes = ListUtils.flattenList(this.nodes);
        }
        return this.flatNodes;
    }

    public int getTotalPoints() {
        return this.totalPoints;
    }

    public void addPoint() {
        ++this.totalPoints;
    }
}

