/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;

public class SkillDataNode {
    private final int id;
    private final String name;
    private final String description;
    private final int limit;
    private int points;
    private final List<SkillDataRequirement> requirements;
    private final String key;
    private final float value;
    private final Optional<SkillSubText> skillSubText;
    public static final Codec<SkillDataNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(SkillDataNode::getId), (App)Codec.STRING.fieldOf("name").forGetter(SkillDataNode::getName), (App)Codec.STRING.fieldOf("description").forGetter(SkillDataNode::getDescription), (App)Codec.INT.fieldOf("limit").forGetter(SkillDataNode::getLimit), (App)Codec.STRING.fieldOf("key").forGetter(SkillDataNode::getKey), (App)Codec.FLOAT.fieldOf("value").forGetter(SkillDataNode::getValue), (App)SkillDataRequirement.CODEC.listOf().fieldOf("requirements").forGetter(SkillDataNode::getRequirements), (App)SkillSubText.CODEC.optionalFieldOf("subtext").forGetter(SkillDataNode::getSkillSubText)).apply((Applicative)instance, SkillDataNode::new));

    public SkillDataNode(int id, String name, String description, int limit, String key, float value, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.limit = limit;
        this.points = 0;
        this.key = key;
        this.value = value;
        this.requirements = requirements;
        this.skillSubText = skillSubText;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getPoints() {
        return this.points;
    }

    public List<SkillDataRequirement> getRequirements() {
        return this.requirements;
    }

    public int addPoint() {
        return this.addPoint(1);
    }

    public String getKey() {
        return this.key;
    }

    public float getValue() {
        return this.value;
    }

    public Optional<SkillSubText> getSkillSubText() {
        return this.skillSubText;
    }

    public int addPoint(int points) {
        this.points += points;
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public boolean canLevel(SkillData data, Player player) {
        for (SkillDataRequirement requirement : this.requirements) {
            if (requirement.canLevel(data, player)) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete() {
        if (this.limit == 0) {
            return false;
        }
        return this.points >= this.limit;
    }

    public String toString() {
        return "SkillDataNode{id=" + this.id + ", name='" + this.name + "', description='" + this.description + "', limit=" + this.limit + ", points=" + this.points + ", requirements=" + String.valueOf(this.requirements) + ", key='" + this.key + "', value=" + this.value + "}";
    }
}

