/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.requirement;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataNodeRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.utils.CodecUtils;
import java.util.List;
import net.minecraft.world.entity.player.Player;

public class NodeOrSkillDataRequirement
implements SkillDataRequirement,
SkillDataNodeRequirement {
    List<Integer> nodes;
    public static final Codec<NodeOrSkillDataRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("or_node").forGetter(NodeOrSkillDataRequirement::getRequiredNodes)).apply((Applicative)instance, NodeOrSkillDataRequirement::new));

    public NodeOrSkillDataRequirement(List<Integer> nodes) {
        this.nodes = nodes;
    }

    @Override
    public boolean canLevel(SkillData data, Player player) {
        List<SkillDataNode> nodes = data.getAllNodes();
        for (SkillDataNode node : nodes) {
            if (!this.nodes.contains(node.getId()) || node.getPoints() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getRequiredNodes() {
        return this.nodes;
    }

    @Override
    public RequirementType getRequirementType() {
        return RequirementType.NODE_OR;
    }

    @Override
    public JsonElement toJson() {
        return CodecUtils.encodeOrThrow(CODEC, this);
    }
}

