/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.requirement;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataNodeRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.utils.CodecUtils;
import java.util.List;
import net.minecraft.world.entity.player.Player;

public class NodeSkillDataRequirement
implements SkillDataRequirement,
SkillDataNodeRequirement {
    List<Integer> requiredNodes;
    boolean inverse;
    List<Integer> unless;
    public static final Codec<NodeSkillDataRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("node").forGetter(NodeSkillDataRequirement::getRequiredNodes)).apply((Applicative)instance, NodeSkillDataRequirement::new));

    public NodeSkillDataRequirement(List<Integer> requiredNodes) {
        this(requiredNodes, false);
    }

    protected NodeSkillDataRequirement(List<Integer> requiredNodes, boolean inverse) {
        this(requiredNodes, inverse, List.of());
    }

    protected NodeSkillDataRequirement(List<Integer> requiredNodes, boolean inverse, List<Integer> unless) {
        this.requiredNodes = requiredNodes;
        this.inverse = inverse;
        this.unless = unless;
    }

    @Override
    public boolean canLevel(SkillData data, Player player) {
        boolean toReturn = true;
        List<SkillDataNode> nodes = data.getAllNodes();
        for (SkillDataNode node : nodes) {
            if (this.requiredNodes.contains(node.getId()) && (!this.inverse && node.getPoints() == 0 || this.inverse && node.getPoints() > 0)) {
                toReturn = false;
            }
            if (!this.inverse || !(this.unless.contains(node.getId()) & node.getPoints() > 0)) continue;
            return true;
        }
        return toReturn;
    }

    @Override
    public List<Integer> getRequiredNodes() {
        return this.requiredNodes;
    }

    protected List<Integer> getUnless() {
        return this.unless;
    }

    @Override
    public RequirementType getRequirementType() {
        return this.inverse ? RequirementType.NODE_NOT : RequirementType.NODE_AND;
    }

    @Override
    public JsonElement toJson() {
        return CodecUtils.encodeOrThrow(CODEC, this);
    }
}

