/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NodeOrSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NodeSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NotNodeSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillItemRequirement;
import dev.willyelton.crystal_tools.utils.CodecUtils;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;

public interface SkillDataRequirement {
    public static final Codec<SkillDataRequirement> CODEC = ExtraCodecs.JSON.xmap(SkillDataRequirement::fromJson, SkillDataRequirement::toJson);

    public boolean canLevel(SkillData var1, Player var2);

    public RequirementType getRequirementType();

    public JsonElement toJson();

    public static SkillDataRequirement fromJson(JsonElement jsonElement) {
        JsonObject requirementObject = jsonElement.getAsJsonObject();
        if (requirementObject.keySet().contains("node")) {
            return CodecUtils.parseOrThrow(NodeSkillDataRequirement.CODEC, jsonElement);
        }
        if (requirementObject.keySet().contains("not_node")) {
            return CodecUtils.parseOrThrow(NotNodeSkillDataRequirement.CODEC, jsonElement);
        }
        if (requirementObject.keySet().contains("or_node")) {
            return CodecUtils.parseOrThrow(NodeOrSkillDataRequirement.CODEC, jsonElement);
        }
        if (requirementObject.keySet().contains("item")) {
            return CodecUtils.parseOrThrow(SkillItemRequirement.CODEC, jsonElement);
        }
        throw new JsonParseException("Bad Requirement: " + String.valueOf(jsonElement));
    }
}

