/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.requirement;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.utils.CodecUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class SkillItemRequirement
implements SkillDataRequirement {
    private final List<Item> items;
    public static final Codec<SkillItemRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().listOf().fieldOf("item").forGetter(SkillItemRequirement::getItems)).apply((Applicative)instance, SkillItemRequirement::new));

    public SkillItemRequirement(String[] items) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (String item : items) {
            ResourceLocation r = ResourceLocation.parse((String)item);
            itemList.add((Item)BuiltInRegistries.ITEM.get(r));
        }
        this.items = itemList;
    }

    public SkillItemRequirement(List<Item> items) {
        this.items = items;
    }

    @Override
    public boolean canLevel(SkillData data, Player player) {
        if (!((Boolean)CrystalToolsConfig.ENABLE_ITEM_REQUIREMENTS.get()).booleanValue()) {
            return true;
        }
        for (Item item : this.items) {
            if (this.hasItem(player, item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasItem(Player player, Item item) {
        Inventory inventory = player.getInventory();
        return inventory.contains(item.getDefaultInstance());
    }

    @Override
    public RequirementType getRequirementType() {
        return RequirementType.ITEM;
    }

    @Override
    public JsonElement toJson() {
        return CodecUtils.encodeOrThrow(CODEC, this);
    }

    public List<Item> getItems() {
        return this.items;
    }
}

