/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.levelable.tool.DiggerLevelableTool;
import dev.willyelton.crystal_tools.common.levelable.tool.UseMode;
import dev.willyelton.crystal_tools.utils.StringUtils;
import dev.willyelton.crystal_tools.utils.ToolUseUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.Tags;

public class AIOLevelableTool
extends DiggerLevelableTool {
    public static final Set<ItemAbility> AIOT_ACTIONS = new HashSet<ItemAbility>();

    public AIOLevelableTool() {
        super(new Item.Properties(), (TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, "aiot", 3.0f, -2.4f);
        AIOT_ACTIONS.addAll(ItemAbilities.DEFAULT_AXE_ACTIONS);
        AIOT_ACTIONS.addAll(ItemAbilities.DEFAULT_HOE_ACTIONS);
        AIOT_ACTIONS.addAll(ItemAbilities.DEFAULT_SHOVEL_ACTIONS);
        AIOT_ACTIONS.addAll(ItemAbilities.DEFAULT_PICKAXE_ACTIONS);
        AIOT_ACTIONS.addAll(ItemAbilities.DEFAULT_SWORD_ACTIONS);
    }

    @Override
    public boolean correctTool(ItemStack tool, BlockState blockState) {
        return blockState.getDestroySpeed(null, null) != -1.0f;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        if (this.isDisabled()) {
            stack.shrink(1);
            return InteractionResult.FAIL;
        }
        UseMode mode = UseMode.fromString((String)stack.getOrDefault(DataComponents.USE_MODE, (Object)""));
        switch (mode) {
            case HOE: {
                return ToolUseUtils.useOnHoe3x3(context, this);
            }
            case SHOVEL: {
                return ToolUseUtils.useOnShovel3x3(context, this);
            }
            case AXE: {
                return ToolUseUtils.useOnAxeVeinStrip(context, this);
            }
            case TORCH: {
                return ToolUseUtils.useOnTorch(context, this);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return AIOT_ACTIONS.contains(itemAbility) || (Boolean)stack.getOrDefault(DataComponents.SHEAR, (Object)false) != false && ItemAbilities.DEFAULT_SHEARS_ACTIONS.contains(itemAbility);
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.correctTool(stack, state);
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)CrystalToolsConfig.DISABLE_AIOT.get();
    }

    @Override
    public boolean canVeinMin(ItemStack stack, BlockState blockState) {
        return blockState.is(Tags.Blocks.ORES) || blockState.is(BlockTags.LOGS) || blockState.is(BlockTags.LEAVES);
    }

    @Override
    public void addAdditionalTooltips(ItemStack stack, List<Component> components, LevelableItem item) {
        String toolTip = "\u00a79Use Mode: " + StringUtils.capitalize(((String)stack.getOrDefault(DataComponents.USE_MODE, (Object)"hoe")).toLowerCase(Locale.ROOT));
        if (RegisterKeyBindingsEvent.MODE_SWITCH != null) {
            toolTip = toolTip + " (alt + " + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to change)";
        }
        components.add((Component)Component.literal((String)toolTip));
    }
}

