/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.EffectData;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.events.LevelTickEvent;
import dev.willyelton.crystal_tools.common.levelable.EntityTargeter;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class BowLevelableItem
extends BowItem
implements LevelableItem,
EntityTargeter {
    public BowLevelableItem() {
        super(new Item.Properties().durability(INITIAL_TIER.getUses()).fireResistant());
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean creative = player.getAbilities().instabuild;
            ItemStack itemstack = (Boolean)stack.getOrDefault(DataComponents.INFINITY, (Object)false) != false ? new ItemStack((ItemLike)Items.ARROW) : this.getProjectile(stack, player);
            int timeUsed = this.getUseDuration(stack, entity) - timeLeft;
            if ((timeUsed = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)timeUsed, (!itemstack.isEmpty() || creative ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.isEmpty() || creative) {
                float power;
                if (itemstack.isEmpty()) {
                    itemstack = new ItemStack((ItemLike)Items.ARROW);
                }
                if ((double)(power = this.getPower(timeUsed, stack)) >= 0.1) {
                    boolean infinity;
                    boolean bl = infinity = creative || itemstack.getItem() instanceof ArrowItem && ((ArrowItem)itemstack.getItem()).isInfinite(itemstack, stack, (LivingEntity)player);
                    if (!level.isClientSide) {
                        float j;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.getItem() instanceof ArrowItem ? itemstack.getItem() : Items.ARROW);
                        AbstractArrow abstractarrow = arrowitem.createArrow(level, itemstack, (LivingEntity)player, stack);
                        abstractarrow = this.customArrow(abstractarrow);
                        float speed = power * 3.0f + ((Float)stack.getOrDefault(DataComponents.ARROW_SPEED, (Object)Float.valueOf(0.0f))).floatValue() / 4.0f;
                        abstractarrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, speed, 0.0f);
                        if (power == 1.0f) {
                            abstractarrow.setCritArrow(true);
                        }
                        if ((j = ((Float)stack.getOrDefault((DataComponentType)DataComponents.ARROW_DAMAGE.get(), (Object)Float.valueOf(0.0f))).floatValue()) > 0.0f) {
                            abstractarrow.setBaseDamage(abstractarrow.getBaseDamage() + (double)j + 0.5);
                        }
                        if (((Boolean)stack.getOrDefault(DataComponents.FLAME, (Object)false)).booleanValue()) {
                            abstractarrow.setRemainingFireTicks(100);
                        }
                        if (abstractarrow instanceof Arrow) {
                            Arrow arrow = (Arrow)abstractarrow;
                            List effects = (List)stack.getOrDefault(DataComponents.EFFECTS, Collections.emptyList());
                            for (EffectData effect : effects) {
                                Optional mobEffect = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.withDefaultNamespace((String)effect.resourceLocation()));
                                if (!mobEffect.isPresent()) continue;
                                MobEffectInstance instance = new MobEffectInstance((Holder)mobEffect.get(), effect.duration() * 20, 1, false, false);
                                arrow.addEffect(instance);
                            }
                        }
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                        if (infinity || ((Boolean)stack.getOrDefault(DataComponents.INFINITY, (Object)false)).booleanValue()) {
                            abstractarrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.addFreshEntity((Entity)abstractarrow);
                        int target = (Integer)stack.getOrDefault(DataComponents.ENTITY_TARGET, (Object)-1);
                        if (target != -1) {
                            LevelTickEvent.startTracking(level, abstractarrow.getId(), target, speed / 2.0f);
                        }
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + power * 0.5f);
                    if (!infinity) {
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            player.getInventory().removeItem(itemstack);
                        }
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        this.refreshTarget(stack, level, (LivingEntity)player);
        if (this.isDisabled()) {
            stack.shrink(1);
            return InteractionResultHolder.fail((Object)stack);
        }
        boolean flag = !this.getProjectile(stack, player).isEmpty() || (Boolean)stack.getOrDefault(DataComponents.INFINITY, (Object)false) != false;
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (ToolUtils.isBroken(stack) || !player.getAbilities().instabuild && !flag) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.refreshTarget(stack, level, livingEntity);
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        this.clearTarget(stack, entity.level());
        super.onStopUsing(stack, entity, count);
    }

    public AbstractArrow customArrow(AbstractArrow arrow) {
        return arrow;
    }

    public ItemStack getProjectile(ItemStack shootable, Player player) {
        return player.getProjectile(shootable);
    }

    @Override
    public String getItemType() {
        return "bow";
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        int bonusDurability = (Integer)stack.getOrDefault(DataComponents.DURABILITY_BONUS, (Object)0);
        return INITIAL_TIER.getUses() + bonusDurability;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.getDamageValue() * 13.0f / (float)itemStack.getMaxDamage());
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.getMaxDamage() - (float)itemStack.getDamageValue()) / (float)itemStack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int inventorySlot, boolean inHand) {
        this.levelableInventoryTick(itemStack, level, entity, inventorySlot, inHand, 1.0);
    }

    public boolean isValidRepairItem(ItemStack tool, ItemStack repairItem) {
        return repairItem.is((Item)Registration.CRYSTAL.get());
    }

    public int getEnchantmentValue() {
        return INITIAL_TIER.getEnchantmentValue();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        this.appendLevelableHoverText(itemStack, components, this, flag);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durability = this.getMaxDamage(stack) - stack.getDamageValue();
        if (durability - amount <= 0) {
            return 0;
        }
        return amount;
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)CrystalToolsConfig.DISABLE_BOW.get();
    }

    public boolean isEnchantable(ItemStack stack) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    public float getChargeTime(ItemStack stack) {
        return Math.max(1.0f, 20.0f - ((Float)stack.getOrDefault(DataComponents.DRAW_SPEED, (Object)Float.valueOf(0.0f))).floatValue());
    }

    private float getPower(int charge, ItemStack stack) {
        float f = (float)charge / this.getChargeTime(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is(oldStack.getItem());
    }
}

