/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.EffectData;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CrystalApple
extends LevelableTool {
    private static final int BASE_NUTRITION = 2;
    private static final float BASE_SATURATION = 0.4f;
    private static final int BASE_EAT_SPEED = 32;

    public CrystalApple() {
        super(new Item.Properties().fireResistant(), null, "apple", -4.0f, 0.0f, 50);
    }

    public FoodProperties getFoodProperties(ItemStack stack, LivingEntity entity) {
        return this.getFoodPropertiesFromNBT(stack);
    }

    private FoodProperties getFoodPropertiesFromNBT(ItemStack stack) {
        int nutrition = 2 + (Integer)stack.getOrDefault(DataComponents.NUTRITION_BONUS, (Object)0);
        float saturation = 0.4f + ((Float)stack.getOrDefault(DataComponents.SATURATION_BONUS, (Object)Float.valueOf(0.0f))).floatValue();
        boolean alwaysEat = (Boolean)stack.getOrDefault(DataComponents.ALWAYS_EAT, (Object)false);
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.nutrition(nutrition).saturationModifier(saturation);
        if (alwaysEat) {
            builder.alwaysEdible();
        }
        List effects = (List)stack.getOrDefault(DataComponents.EFFECTS, Collections.emptyList());
        for (EffectData effect : effects) {
            Optional mobEffect = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.withDefaultNamespace((String)effect.resourceLocation()));
            if (!mobEffect.isPresent()) continue;
            MobEffectInstance instance = new MobEffectInstance((Holder)mobEffect.get(), effect.duration() * 20, 1, false, false);
            builder.effect(() -> instance, 1.0f);
        }
        return builder.build();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (this.isDisabled()) {
            itemstack.shrink(1);
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (itemstack.getItem() instanceof CrystalApple) {
            FoodProperties foodProperties = itemstack.getFoodProperties((LivingEntity)player);
            if (foodProperties != null && player.canEat(foodProperties.canAlwaysEat()) && !ToolUtils.isBroken(itemstack)) {
                player.startUsingItem(usedHand);
                return InteractionResultHolder.pass((Object)itemstack);
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        int eatSpeed = 32 - (Integer)stack.getOrDefault(DataComponents.EAT_SPEED_BONUS, (Object)0);
        return Math.max(eatSpeed, 4);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity player) {
        player.eat(level, stack);
        if (!(player instanceof Player) || !((Player)player).getAbilities().instabuild) {
            stack.grow(1);
        }
        int nutrition = 2 + (Integer)stack.getOrDefault(DataComponents.NUTRITION_BONUS, (Object)0);
        float saturation = 0.4f + ((Float)stack.getOrDefault(DataComponents.SATURATION_BONUS, (Object)Float.valueOf(0.0f))).floatValue();
        int effectiveHunger = (int)((float)nutrition * saturation * 2.0f) + nutrition;
        this.addExp(stack, level, player.getOnPos(), player, (int)((double)effectiveHunger * (Double)CrystalToolsConfig.APPLE_EXPERIENCE_BOOST.get()));
        stack.hurtAndBreak(1, player, EquipmentSlot.MAINHAND);
        return stack;
    }

    @Override
    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int inventorySlot, boolean inHand) {
        this.levelableInventoryTick(itemStack, level, entity, inventorySlot, inHand, (Double)CrystalToolsConfig.APPLE_REPAIR_MODIFIER.get());
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)CrystalToolsConfig.DISABLE_APPLE.get();
    }

    @Override
    public boolean mineBlock(ItemStack tool, Level level, BlockState blockState, BlockPos blockPos, LivingEntity entity) {
        if (this.isDisabled()) {
            tool.shrink(1);
            return false;
        }
        return true;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.EAT;
    }
}

