/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalMagnetContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentType;

public class CrystalMagnet
extends LevelableTool {
    public CrystalMagnet() {
        super(new Item.Properties().durability(2000).component(DataComponents.WHITELIST, (Object)false), null, "magnet", 0.0f, 0.0f, 2000);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int inventorySlot, boolean inHand) {
        super.inventoryTick(stack, level, entity, inventorySlot, inHand);
        if (!((Boolean)stack.getOrDefault(DataComponents.DISABLED, (Object)false)).booleanValue()) {
            float speed = 0.01f + ((Float)stack.getOrDefault(DataComponents.ITEM_SPEED, (Object)Float.valueOf(0.0f))).floatValue();
            float size = this.getRange(stack);
            List<ItemStack> filterStacks = ToolUtils.getFilterItems(stack);
            AtomicInteger affected = new AtomicInteger();
            List entities = level.getEntities(entity, AABB.ofSize((Vec3)entity.position(), (double)(size * 2.0f), (double)(size * 2.0f), (double)(size * 2.0f)), this.createPredicate(stack));
            entities.forEach(e -> {
                if (e instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)e;
                    if (itemEntity.hasPickUpDelay()) {
                        return;
                    }
                    if (!ToolUtils.matchesFilter(stack, itemEntity.getItem(), filterStacks)) {
                        return;
                    }
                    if (((Boolean)stack.getOrDefault(DataComponents.INSTANT_PICKUP, (Object)false)).booleanValue() && entity instanceof Player) {
                        Player player = (Player)entity;
                        itemEntity.playerTouch(player);
                        stack.hurtAndBreak(1, (LivingEntity)player, null);
                        return;
                    }
                }
                e.push(entity.position().subtract(e.position()).normalize().scale((double)speed));
                e.setData((AttachmentType)Registration.MAGNET_ITEM.get(), (Object)true);
                affected.getAndIncrement();
            });
            if (affected.get() > 0 && level.getGameTime() % 5L == 0L && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                stack.hurtAndBreak(affected.get(), livingEntity, null);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openMagnetFilter(serverPlayer, stack, serverPlayer.getInventory().findSlotMatchingItem(stack));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (((Boolean)stack.getOrDefault(DataComponents.DISABLED, (Object)false)).booleanValue()) {
            components.add((Component)Component.literal((String)("\u00a7c\u00a7lDisabled (" + RegisterKeyBindingsEvent.TOGGLE_MAGNET.getKey().getDisplayName().getString() + " to enable)")));
        }
        components.add((Component)Component.literal((String)String.format("Range: %.1f Blocks", Float.valueOf(this.getRange(stack)))));
        if (((Boolean)stack.getOrDefault(DataComponents.PULL_MOBS, (Object)false)).booleanValue()) {
            Object toolTip = (Boolean)stack.getOrDefault(DataComponents.DISABLE_MOB_PULL, (Object)false) != false ? "\u00a7c\u00a7lMob Pulling Disabled" : "\u00a79Mob Pulling Enabled";
            if (RegisterKeyBindingsEvent.TOGGLE_MAGNET != null) {
                toolTip = (String)toolTip + " (shift + " + RegisterKeyBindingsEvent.TOGGLE_MAGNET.getKey().getDisplayName().getString() + " to change)";
            }
            components.add((Component)Component.literal((String)toolTip));
        }
    }

    public void openMagnetFilter(ServerPlayer serverPlayer, ItemStack stack, int slotIndex) {
        serverPlayer.openMenu((MenuProvider)new CrystalMagnetMenuSupplier(this, stack, slotIndex), friendlyByteBuf -> {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(friendlyByteBuf, (Object)stack);
            friendlyByteBuf.writeInt(slotIndex);
        });
    }

    private Predicate<Entity> createPredicate(ItemStack stack) {
        boolean includeExp = (Boolean)stack.getOrDefault(DataComponents.PULL_XP, (Object)false);
        boolean includeMobs = (Boolean)stack.getOrDefault(DataComponents.PULL_MOBS, (Object)false) != false && (Boolean)stack.getOrDefault(DataComponents.DISABLE_MOB_PULL, (Object)false) == false;
        return e -> {
            LivingEntity livingEntity;
            if (e instanceof ItemEntity) {
                return true;
            }
            if (includeExp && e instanceof ExperienceOrb) {
                return true;
            }
            return includeMobs && e instanceof LivingEntity && (livingEntity = (LivingEntity)e).isPushable() && !(livingEntity instanceof Player);
        };
    }

    private float getRange(ItemStack stack) {
        return (float)((Double)CrystalToolsConfig.MAGNET_BASE_RANGE.get()).doubleValue() + ((Float)stack.getOrDefault(DataComponents.MAGNET_RANGE, (Object)Float.valueOf(0.0f))).floatValue();
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    private record CrystalMagnetMenuSupplier(CrystalMagnet magnetItem, ItemStack stack, int slotIndex) implements MenuProvider
    {
        public Component getDisplayName() {
            return this.stack.getHoverName();
        }

        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            return new CrystalMagnetContainerMenu(containerId, playerInventory, this.stack, this.slotIndex);
        }
    }
}

