/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.Level;

public class CrystalRocket
extends LevelableTool {
    public CrystalRocket() {
        super(new Item.Properties(), null, "crystal_rocket", -4.0f, 0.0f, 100);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return this.use(player.getItemInHand(hand), level, player, hand);
    }

    public InteractionResultHolder<ItemStack> use(ItemStack stack, Level level, Player player, InteractionHand hand) {
        if (this.isDisabled()) {
            stack.shrink(1);
            return InteractionResultHolder.fail((Object)stack);
        }
        if (ToolUtils.isBroken(stack)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isFallFlying()) {
            if (!level.isClientSide) {
                int flightTime = (Integer)stack.getOrDefault(DataComponents.FLIGHT_TIME, (Object)1);
                Fireworks fireworks = new Fireworks(flightTime, Collections.emptyList());
                stack.set(net.minecraft.core.component.DataComponents.FIREWORKS, (Object)fireworks);
                FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, stack, (LivingEntity)player);
                level.addFreshEntity((Entity)fireworkrocketentity);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            this.addExp(stack, level, player.getOnPos(), (LivingEntity)player, (Integer)CrystalToolsConfig.ROCKET_EXPERIENCE_BOOST.get());
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    @Override
    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int inventorySlot, boolean inHand) {
        this.levelableInventoryTick(itemStack, level, entity, inventorySlot, inHand, (Double)CrystalToolsConfig.ROCKET_REPAIR_MODIFIER.get());
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)CrystalToolsConfig.DISABLE_ROCKET.get();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flag) {
        tooltipComponents.add((Component)Component.literal((String)String.format("Press %s while this is in your inventory to automatically use!", RegisterKeyBindingsEvent.TRIGGER_ROCKET.getKey().getDisplayName().getString())));
        super.appendHoverText(stack, context, tooltipComponents, flag);
    }
}

