/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.EntityTargeter;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.levelable.armor.LevelableArmor;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.NotNull;

public class CrystalShield
extends ShieldItem
implements LevelableItem,
EntityTargeter {
    public CrystalShield() {
        super(new Item.Properties().durability(1000).component(net.minecraft.core.component.DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        this.refreshTarget(stack, level, (LivingEntity)player);
        return super.use(level, player, hand);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.refreshTarget(stack, level, livingEntity);
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        this.clearTarget(stack, entity.level());
        super.onStopUsing(stack, entity, count);
    }

    @Override
    public String getItemType() {
        return "shield";
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        this.appendLevelableHoverText(stack, tooltipComponents, this, tooltipFlag);
    }

    @Override
    public void addAdditionalTooltips(ItemStack stack, List<Component> components, LevelableItem item) {
        int totemSlots = (Integer)stack.getOrDefault(DataComponents.TOTEM_SLOTS, (Object)0);
        if (totemSlots > 0) {
            components.add((Component)Component.literal((String)String.format("\u00a72%d/%d Totems of Undying", stack.getOrDefault(DataComponents.FILLED_TOTEM_SLOTS, (Object)0), totemSlots)));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        int bonusDurability = (Integer)stack.getOrDefault(DataComponents.DURABILITY_BONUS, (Object)0);
        return (Integer)stack.getOrDefault(net.minecraft.core.component.DataComponents.MAX_DAMAGE, (Object)0) + bonusDurability;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durability = this.getMaxDamage(stack) - stack.getDamageValue();
        if (durability - amount <= 0) {
            return 0;
        }
        return amount;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.getDamageValue() * 13.0f / (float)itemStack.getMaxDamage());
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.getMaxDamage() - (float)itemStack.getDamageValue()) / (float)itemStack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        this.levelableInventoryTick(stack, level, entity, slotId, isSelected, 1.0);
    }

    public boolean isValidRepairItem(ItemStack tool, ItemStack repairItem) {
        return repairItem.is((Item)Registration.CRYSTAL.get());
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    @Override
    public ItemAttributeModifiers getLevelableAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        if (!ToolUtils.isBroken(stack)) {
            float attackDamage;
            int armor = (Integer)stack.getOrDefault(DataComponents.ARMOR_BONUS, (Object)0);
            if (armor > 0) {
                builder.add(Attributes.ARMOR, new AttributeModifier(LevelableArmor.ARMOR_ID, (double)armor, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.OFFHAND);
            }
            if ((attackDamage = ((Float)stack.getOrDefault(DataComponents.DAMAGE_BONUS, (Object)Float.valueOf(0.0f))).floatValue()) > 0.0f) {
                builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(LevelableTool.ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
        }
        return builder.build();
    }
}

