/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.network.data.BlockBreakPayload;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class LevelableTool
extends TieredItem
implements LevelableItem {
    protected static final ResourceLocation ATTACK_DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"attack_damage");
    protected static final ResourceLocation ATTACK_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"attack_speed");
    protected static final ResourceLocation ATTACK_KNOCKBACK_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"attack_knockback");
    protected static final ResourceLocation KNOCKBACK_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"knockback_resistance");
    protected static final ResourceLocation REACH_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"reach");
    protected static final ResourceLocation ATTACK_RANGE_ID = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"attack_range");
    protected final TagKey<Block> blocks;
    protected final String itemType;
    protected final int initialDurability;
    private final float initialAttackDamage;

    public LevelableTool(Item.Properties properties, TagKey<Block> mineableBlocks, String itemType, float attackDamageModifier, float attackSpeedModifier) {
        this(properties, mineableBlocks, itemType, attackDamageModifier, attackSpeedModifier, INITIAL_TIER.getUses());
    }

    public LevelableTool(Item.Properties properties, TagKey<Block> mineableBlocks, String itemType, float attackDamageModifier, float attackSpeedModifier, int durability) {
        super((Tier)Tiers.NETHERITE, properties.fireResistant().rarity(Rarity.RARE).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(INITIAL_TIER.getAttackDamageBonus() + attackDamageModifier), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeedModifier, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
        this.blocks = mineableBlocks;
        this.itemType = itemType;
        this.initialDurability = durability;
        this.initialAttackDamage = INITIAL_TIER.getAttackDamageBonus() + attackDamageModifier;
    }

    public float getDestroySpeed(ItemStack tool, BlockState blockState) {
        float bonus = ((Float)tool.getOrDefault(DataComponents.MINING_SPEED, (Object)Float.valueOf(0.0f))).floatValue();
        if (ToolUtils.isBroken(tool)) {
            return 0.1f;
        }
        return this.correctTool(tool, blockState) ? this.getTier().getSpeed() + bonus * 20.0f : 1.0f;
    }

    public boolean correctTool(ItemStack tool, BlockState blockState) {
        return this.blocks != null && blockState.is(this.blocks);
    }

    public boolean hurtEnemy(ItemStack tool, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled()) {
            tool.shrink(1);
            return false;
        }
        tool.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (!ToolUtils.isBroken(tool)) {
            if (((Boolean)tool.getOrDefault(DataComponents.FIRE, (Object)false)).booleanValue()) {
                target.setRemainingFireTicks(5);
            }
            if (ToolUtils.isValidEntity(target)) {
                int heal = (Integer)tool.getOrDefault(DataComponents.LIFESTEAL, (Object)0);
                if (heal > 0) {
                    attacker.heal((float)heal);
                }
                this.addExp(tool, target.level(), attacker.getOnPos(), attacker, (int)((double)this.getAttackDamage(tool) * this.getAttackExperienceBoost()));
            }
        }
        return true;
    }

    public boolean mineBlock(ItemStack tool, Level level, BlockState blockState, BlockPos blockPos, LivingEntity entity) {
        if (this.isDisabled()) {
            tool.shrink(1);
            return false;
        }
        if (!level.isClientSide) {
            tool.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
        }
        this.addExp(tool, level, blockPos, entity);
        return true;
    }

    public void breakBlock(ItemStack tool, Level level, BlockPos blockPos, LivingEntity entity) {
        BlockState blockState = level.getBlockState(blockPos);
        if (this.isCorrectToolForDrops(tool, blockState) && !ToolUtils.isBroken(tool) && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!level.isClientSide) {
                Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)blockPos, (BlockEntity)level.getBlockEntity(blockPos), (Entity)entity, (ItemStack)tool);
                level.destroyBlock(blockPos, false, (Entity)entity);
                tool.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
            }
            this.addExp(tool, level, blockPos, entity);
        }
    }

    public void breakBlockCollection(ItemStack tool, Level level, Collection<BlockPos> blockPosCollection, LivingEntity entity, float firstBlockSpeed) {
        this.breakBlockCollection(tool, level, blockPosCollection, entity, firstBlockSpeed, false);
    }

    public void breakBlockCollection(ItemStack tool, Level level, Collection<BlockPos> blockPosCollection, LivingEntity entity, float firstBlockSpeed, boolean sendServerPackets) {
        for (BlockPos pos : blockPosCollection) {
            if (!(level.getBlockState(pos).getDestroySpeed((BlockGetter)level, pos) <= firstBlockSpeed + 20.0f)) continue;
            this.breakBlock(tool, level, pos, entity);
            if (!sendServerPackets) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new BlockBreakPayload(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.correctTool(stack, state) && INITIAL_TIER.createToolProperties(this.blocks).isCorrectForDrops(state);
    }

    @Override
    public String getItemType() {
        return this.itemType;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        int bonusDurability = (Integer)stack.getOrDefault(DataComponents.DURABILITY_BONUS, (Object)0);
        return this.initialDurability + bonusDurability;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.getDamageValue() * 13.0f / (float)itemStack.getMaxDamage());
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.getMaxDamage() - (float)itemStack.getDamageValue()) / (float)itemStack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int inventorySlot, boolean inHand) {
        this.levelableInventoryTick(itemStack, level, entity, inventorySlot, inHand, 1.0);
    }

    public boolean isValidRepairItem(ItemStack tool, ItemStack repairItem) {
        return repairItem.is((Item)Registration.CRYSTAL.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flag) {
        this.appendLevelableHoverText(stack, tooltipComponents, this, flag);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durability = this.getMaxDamage(stack) - stack.getDamageValue();
        float unbreakingLevel = ((Float)stack.getOrDefault(DataComponents.UNBREAKING, (Object)Float.valueOf(0.0f))).floatValue();
        int damageToTake = 0;
        while (amount > 0) {
            if ((double)unbreakingLevel < Math.random()) {
                ++damageToTake;
            }
            --amount;
        }
        if (durability - damageToTake <= 0) {
            return 0;
        }
        return damageToTake;
    }

    @Override
    public ItemAttributeModifiers getLevelableAttributeModifiers(ItemStack stack) {
        if (!ToolUtils.isBroken(stack)) {
            float reach;
            float knockbackResistance;
            float attackKnockback;
            float attackSpeed;
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            float attackDamage = ((Float)stack.getOrDefault(DataComponents.DAMAGE_BONUS, (Object)Float.valueOf(0.0f))).floatValue();
            if (attackDamage > 0.0f) {
                builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
            if ((attackSpeed = ((Float)stack.getOrDefault(DataComponents.ATTACK_SPEED, (Object)Float.valueOf(0.0f))).floatValue()) > 0.0f) {
                builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
            if ((attackKnockback = ((Float)stack.getOrDefault(DataComponents.KNOCKBACK, (Object)Float.valueOf(0.0f))).floatValue()) > 0.0f) {
                builder.add(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(ATTACK_KNOCKBACK_ID, (double)attackKnockback, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
            if ((knockbackResistance = ((Float)stack.getOrDefault(DataComponents.KNOCKBACK_RESISTANCE, (Object)Float.valueOf(0.0f))).floatValue()) > 0.0f) {
                builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(KNOCKBACK_RESISTANCE_ID, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
            if ((reach = ((Float)stack.getOrDefault(DataComponents.REACH, (Object)Float.valueOf(0.0f))).floatValue()) > 0.0f) {
                builder.add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(REACH_ID, (double)reach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(ATTACK_RANGE_ID, (double)reach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
            return builder.build();
        }
        return ItemAttributeModifiers.builder().build();
    }

    public boolean isEnchantable(ItemStack stack) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return (Boolean)CrystalToolsConfig.ENCHANT_TOOLS.get();
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.initialAttackDamage + ((Float)stack.getOrDefault(DataComponents.DAMAGE_BONUS, (Object)Float.valueOf(0.0f))).floatValue();
    }

    protected double getAttackExperienceBoost() {
        return 1.0;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is(oldStack.getItem());
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (this.isDisabled()) {
            stack.shrink(1);
            return InteractionResult.FAIL;
        }
        if (((Boolean)stack.getOrDefault(DataComponents.SHEAR, (Object)false)).booleanValue() && entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (entity.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = BlockPos.containing((Position)entity.position());
            if (target.isShearable(player, stack, entity.level(), pos)) {
                List drops = target.onSheared(player, stack, entity.level(), pos);
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                    if (ent != null) {
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

