/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.tool.DiggerLevelableTool;
import dev.willyelton.crystal_tools.utils.ToolUseUtils;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class ShovelLevelableTool
extends DiggerLevelableTool {
    public ShovelLevelableTool() {
        super(new Item.Properties(), (TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL, "shovel", 1.5f, -3.0f);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext pContext) {
        if (this.isDisabled()) {
            pContext.getItemInHand().shrink(1);
            return InteractionResult.FAIL;
        }
        return ToolUseUtils.useOnShovel3x3(pContext, this);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(itemAbility);
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)CrystalToolsConfig.DISABLE_SHOVEL.get();
    }
}

